/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.DBEngineVersion;
import software.amazon.awssdk.services.neptune.model.DBEngineVersionListCopier;
import software.amazon.awssdk.services.neptune.model.NeptuneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbEngineVersionsResponse
extends NeptuneResponse
implements ToCopyableBuilder<Builder, DescribeDbEngineVersionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbEngineVersionsResponse.getter(DescribeDbEngineVersionsResponse::marker)).setter(DescribeDbEngineVersionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBEngineVersion>> DB_ENGINE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDbEngineVersionsResponse.getter(DescribeDbEngineVersionsResponse::dbEngineVersions)).setter(DescribeDbEngineVersionsResponse.setter(Builder::dbEngineVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersions").build(), ListTrait.builder().memberLocationName("DBEngineVersion").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBEngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBEngineVersion").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_ENGINE_VERSIONS_FIELD));
    private final String marker;
    private final List<DBEngineVersion> dbEngineVersions;

    private DescribeDbEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbEngineVersions = builder.dbEngineVersions;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBEngineVersion> dbEngineVersions() {
        return this.dbEngineVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbEngineVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbEngineVersionsResponse)) {
            return false;
        }
        DescribeDbEngineVersionsResponse other = (DescribeDbEngineVersionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbEngineVersions(), other.dbEngineVersions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbEngineVersionsResponse").add("Marker", (Object)this.marker()).add("DBEngineVersions", this.dbEngineVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBEngineVersions": {
                return Optional.ofNullable(clazz.cast(this.dbEngineVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbEngineVersionsResponse, T> g) {
        return obj -> g.apply((DescribeDbEngineVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBEngineVersion> dbEngineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbEngineVersionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbEngineVersions(model.dbEngineVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBEngineVersion.Builder> getDbEngineVersions() {
            return this.dbEngineVersions != null ? (Collection)this.dbEngineVersions.stream().map(DBEngineVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbEngineVersions(Collection<DBEngineVersion> dbEngineVersions) {
            this.dbEngineVersions = DBEngineVersionListCopier.copy(dbEngineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbEngineVersions(DBEngineVersion ... dbEngineVersions) {
            this.dbEngineVersions(Arrays.asList(dbEngineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbEngineVersions(Consumer<DBEngineVersion.Builder> ... dbEngineVersions) {
            this.dbEngineVersions(Stream.of(dbEngineVersions).map(c -> (DBEngineVersion)((DBEngineVersion.Builder)DBEngineVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbEngineVersions(Collection<DBEngineVersion.BuilderImpl> dbEngineVersions) {
            this.dbEngineVersions = DBEngineVersionListCopier.copyFromBuilder(dbEngineVersions);
        }

        @Override
        public DescribeDbEngineVersionsResponse build() {
            return new DescribeDbEngineVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbEngineVersionsResponse> {
        public Builder marker(String var1);

        public Builder dbEngineVersions(Collection<DBEngineVersion> var1);

        public Builder dbEngineVersions(DBEngineVersion ... var1);

        public Builder dbEngineVersions(Consumer<DBEngineVersion.Builder> ... var1);
    }
}

