/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.NeptuneResponse;
import software.amazon.awssdk.services.neptune.model.PendingMaintenanceActionsCopier;
import software.amazon.awssdk.services.neptune.model.ResourcePendingMaintenanceActions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePendingMaintenanceActionsResponse
extends NeptuneResponse
implements ToCopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
    private static final SdkField<List<ResourcePendingMaintenanceActions>> PENDING_MAINTENANCE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PendingMaintenanceActions").getter(DescribePendingMaintenanceActionsResponse.getter(DescribePendingMaintenanceActionsResponse::pendingMaintenanceActions)).setter(DescribePendingMaintenanceActionsResponse.setter(Builder::pendingMaintenanceActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingMaintenanceActions").build(), ListTrait.builder().memberLocationName("ResourcePendingMaintenanceActions").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePendingMaintenanceActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePendingMaintenanceActions").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribePendingMaintenanceActionsResponse.getter(DescribePendingMaintenanceActionsResponse::marker)).setter(DescribePendingMaintenanceActionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_MAINTENANCE_ACTIONS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePendingMaintenanceActionsResponse.memberNameToFieldInitializer();
    private final List<ResourcePendingMaintenanceActions> pendingMaintenanceActions;
    private final String marker;

    private DescribePendingMaintenanceActionsResponse(BuilderImpl builder) {
        super(builder);
        this.pendingMaintenanceActions = builder.pendingMaintenanceActions;
        this.marker = builder.marker;
    }

    public final boolean hasPendingMaintenanceActions() {
        return this.pendingMaintenanceActions != null && !(this.pendingMaintenanceActions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePendingMaintenanceActions> pendingMaintenanceActions() {
        return this.pendingMaintenanceActions;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingMaintenanceActions() ? this.pendingMaintenanceActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingMaintenanceActionsResponse)) {
            return false;
        }
        DescribePendingMaintenanceActionsResponse other = (DescribePendingMaintenanceActionsResponse)((Object)obj);
        return this.hasPendingMaintenanceActions() == other.hasPendingMaintenanceActions() && Objects.equals(this.pendingMaintenanceActions(), other.pendingMaintenanceActions()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePendingMaintenanceActionsResponse").add("PendingMaintenanceActions", this.hasPendingMaintenanceActions() ? this.pendingMaintenanceActions() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PendingMaintenanceActions": {
                return Optional.ofNullable(clazz.cast(this.pendingMaintenanceActions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PendingMaintenanceActions", PENDING_MAINTENANCE_ACTIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePendingMaintenanceActionsResponse, T> g) {
        return obj -> g.apply((DescribePendingMaintenanceActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneResponse.BuilderImpl
    implements Builder {
        private List<ResourcePendingMaintenanceActions> pendingMaintenanceActions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingMaintenanceActionsResponse model) {
            super(model);
            this.pendingMaintenanceActions(model.pendingMaintenanceActions);
            this.marker(model.marker);
        }

        public final List<ResourcePendingMaintenanceActions.Builder> getPendingMaintenanceActions() {
            List<ResourcePendingMaintenanceActions.Builder> result = PendingMaintenanceActionsCopier.copyToBuilder(this.pendingMaintenanceActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions.BuilderImpl> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copyFromBuilder(pendingMaintenanceActions);
        }

        @Override
        public final Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copy(pendingMaintenanceActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions ... pendingMaintenanceActions) {
            this.pendingMaintenanceActions(Arrays.asList(pendingMaintenanceActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(Consumer<ResourcePendingMaintenanceActions.Builder> ... pendingMaintenanceActions) {
            this.pendingMaintenanceActions(Stream.of(pendingMaintenanceActions).map(c -> (ResourcePendingMaintenanceActions)((ResourcePendingMaintenanceActions.Builder)ResourcePendingMaintenanceActions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribePendingMaintenanceActionsResponse build() {
            return new DescribePendingMaintenanceActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptuneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
        public Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> var1);

        public Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions ... var1);

        public Builder pendingMaintenanceActions(Consumer<ResourcePendingMaintenanceActions.Builder> ... var1);

        public Builder marker(String var1);
    }
}

