/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FailoverStatus {
    PENDING("pending"),
    FAILING_OVER("failing-over"),
    CANCELLING("cancelling"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FailoverStatus> VALUE_MAP;
    private final String value;

    private FailoverStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailoverStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailoverStatus> knownValues() {
        EnumSet<FailoverStatus> knownValues = EnumSet.allOf(FailoverStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FailoverStatus.class, FailoverStatus::toString);
    }
}

