/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.ReadersArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalClusterMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalClusterMember> {
    private static final SdkField<String> DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterArn").getter(GlobalClusterMember.getter(GlobalClusterMember::dbClusterArn)).setter(GlobalClusterMember.setter(Builder::dbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterArn").build()}).build();
    private static final SdkField<List<String>> READERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Readers").getter(GlobalClusterMember.getter(GlobalClusterMember::readers)).setter(GlobalClusterMember.setter(Builder::readers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Readers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_WRITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsWriter").getter(GlobalClusterMember.getter(GlobalClusterMember::isWriter)).setter(GlobalClusterMember.setter(Builder::isWriter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsWriter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ARN_FIELD, READERS_FIELD, IS_WRITER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBClusterArn", DB_CLUSTER_ARN_FIELD);
            this.put("Readers", READERS_FIELD);
            this.put("IsWriter", IS_WRITER_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dbClusterArn;
    private final List<String> readers;
    private final Boolean isWriter;

    private GlobalClusterMember(BuilderImpl builder) {
        this.dbClusterArn = builder.dbClusterArn;
        this.readers = builder.readers;
        this.isWriter = builder.isWriter;
    }

    public final String dbClusterArn() {
        return this.dbClusterArn;
    }

    public final boolean hasReaders() {
        return this.readers != null && !(this.readers instanceof SdkAutoConstructList);
    }

    public final List<String> readers() {
        return this.readers;
    }

    public final Boolean isWriter() {
        return this.isWriter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReaders() ? this.readers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isWriter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalClusterMember)) {
            return false;
        }
        GlobalClusterMember other = (GlobalClusterMember)obj;
        return Objects.equals(this.dbClusterArn(), other.dbClusterArn()) && this.hasReaders() == other.hasReaders() && Objects.equals(this.readers(), other.readers()) && Objects.equals(this.isWriter(), other.isWriter());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalClusterMember").add("DBClusterArn", (Object)this.dbClusterArn()).add("Readers", this.hasReaders() ? this.readers() : null).add("IsWriter", (Object)this.isWriter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterArn": {
                return Optional.ofNullable(clazz.cast(this.dbClusterArn()));
            }
            case "Readers": {
                return Optional.ofNullable(clazz.cast(this.readers()));
            }
            case "IsWriter": {
                return Optional.ofNullable(clazz.cast(this.isWriter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GlobalClusterMember, T> g) {
        return obj -> g.apply((GlobalClusterMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterArn;
        private List<String> readers = DefaultSdkAutoConstructList.getInstance();
        private Boolean isWriter;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalClusterMember model) {
            this.dbClusterArn(model.dbClusterArn);
            this.readers(model.readers);
            this.isWriter(model.isWriter);
        }

        public final String getDbClusterArn() {
            return this.dbClusterArn;
        }

        public final void setDbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final Collection<String> getReaders() {
            if (this.readers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readers;
        }

        public final void setReaders(Collection<String> readers) {
            this.readers = ReadersArnListCopier.copy(readers);
        }

        @Override
        public final Builder readers(Collection<String> readers) {
            this.readers = ReadersArnListCopier.copy(readers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readers(String ... readers) {
            this.readers(Arrays.asList(readers));
            return this;
        }

        public final Boolean getIsWriter() {
            return this.isWriter;
        }

        public final void setIsWriter(Boolean isWriter) {
            this.isWriter = isWriter;
        }

        @Override
        public final Builder isWriter(Boolean isWriter) {
            this.isWriter = isWriter;
            return this;
        }

        public GlobalClusterMember build() {
            return new GlobalClusterMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalClusterMember> {
        public Builder dbClusterArn(String var1);

        public Builder readers(Collection<String> var1);

        public Builder readers(String ... var1);

        public Builder isWriter(Boolean var1);
    }
}

