/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.neptune.model.Parameter;

public class DescribeDBParametersPublisher
implements SdkPublisher<DescribeDbParametersResponse> {
    private final NeptuneAsyncClient client;
    private final DescribeDbParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBParametersPublisher(NeptuneAsyncClient client, DescribeDbParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBParametersPublisher(NeptuneAsyncClient client, DescribeDbParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Parameter> parameters() {
        Function<DescribeDbParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbParametersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbParametersResponseFetcher
    implements AsyncPageFetcher<DescribeDbParametersResponse> {
        private DescribeDbParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbParametersResponse> nextPage(DescribeDbParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParametersPublisher.this.client.describeDBParameters(DescribeDBParametersPublisher.this.firstRequest);
            }
            return DescribeDBParametersPublisher.this.client.describeDBParameters((DescribeDbParametersRequest)((Object)DescribeDBParametersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

