/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.neptune.DefaultNeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.DefaultNeptuneBaseClientBuilder;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClientBuilder;
import software.amazon.awssdk.services.neptune.NeptuneServiceClientConfiguration;
import software.amazon.awssdk.services.neptune.endpoints.NeptuneEndpointProvider;

@SdkInternalApi
final class DefaultNeptuneAsyncClientBuilder
extends DefaultNeptuneBaseClientBuilder<NeptuneAsyncClientBuilder, NeptuneAsyncClient>
implements NeptuneAsyncClientBuilder {
    DefaultNeptuneAsyncClientBuilder() {
    }

    @Override
    public DefaultNeptuneAsyncClientBuilder endpointProvider(NeptuneEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final NeptuneAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultNeptuneAsyncClientBuilder.validateClientOptions(clientConfiguration);
        NeptuneServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultNeptuneAsyncClient client = new DefaultNeptuneAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private NeptuneServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return NeptuneServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

