/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.neptune.DefaultNeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.DefaultNeptuneBaseClientBuilder;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClientBuilder;
import software.amazon.awssdk.services.neptune.NeptuneServiceClientConfiguration;
import software.amazon.awssdk.services.neptune.endpoints.NeptuneEndpointProvider;

@SdkInternalApi
final class DefaultNeptuneAsyncClientBuilder
extends DefaultNeptuneBaseClientBuilder<NeptuneAsyncClientBuilder, NeptuneAsyncClient>
implements NeptuneAsyncClientBuilder {
    DefaultNeptuneAsyncClientBuilder() {
    }

    @Override
    public DefaultNeptuneAsyncClientBuilder endpointProvider(NeptuneEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final NeptuneAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultNeptuneAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        NeptuneServiceClientConfiguration serviceClientConfiguration = NeptuneServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultNeptuneAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

