/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneAsyncClient;
import software.amazon.awssdk.services.neptune.model.DBSubnetGroup;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse;

public class DescribeDBSubnetGroupsPublisher
implements SdkPublisher<DescribeDbSubnetGroupsResponse> {
    private final NeptuneAsyncClient client;
    private final DescribeDbSubnetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBSubnetGroupsPublisher(NeptuneAsyncClient client, DescribeDbSubnetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBSubnetGroupsPublisher(NeptuneAsyncClient client, DescribeDbSubnetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbSubnetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbSubnetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBSubnetGroup> dbSubnetGroups() {
        Function<DescribeDbSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSubnetGroups() != null) {
                return response.dbSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbSubnetGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbSubnetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeDbSubnetGroupsResponse> {
        private DescribeDbSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbSubnetGroupsResponse> nextPage(DescribeDbSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSubnetGroupsPublisher.this.client.describeDBSubnetGroups(DescribeDBSubnetGroupsPublisher.this.firstRequest);
            }
            return DescribeDBSubnetGroupsPublisher.this.client.describeDBSubnetGroups((DescribeDbSubnetGroupsRequest)((Object)DescribeDBSubnetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

