/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.neptune.model.DBClusterEndpoint;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsResponse;

public class DescribeDBClusterEndpointsIterable
implements SdkIterable<DescribeDbClusterEndpointsResponse> {
    private final NeptuneClient client;
    private final DescribeDbClusterEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBClusterEndpointsIterable(NeptuneClient client, DescribeDbClusterEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbClusterEndpointsResponseFetcher();
    }

    public Iterator<DescribeDbClusterEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBClusterEndpoint> dbClusterEndpoints() {
        Function<DescribeDbClusterEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbClusterEndpoints() != null) {
                return response.dbClusterEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbClusterEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeDbClusterEndpointsResponse> {
        private DescribeDbClusterEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbClusterEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbClusterEndpointsResponse nextPage(DescribeDbClusterEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBClusterEndpointsIterable.this.client.describeDBClusterEndpoints(DescribeDBClusterEndpointsIterable.this.firstRequest);
            }
            return DescribeDBClusterEndpointsIterable.this.client.describeDBClusterEndpoints((DescribeDbClusterEndpointsRequest)((Object)DescribeDBClusterEndpointsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

