/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainMembership
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainMembership> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DomainMembership.getter(DomainMembership::domain)).setter(DomainMembership.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DomainMembership.getter(DomainMembership::status)).setter(DomainMembership.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FQDN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FQDN").getter(DomainMembership.getter(DomainMembership::fqdn)).setter(DomainMembership.setter(Builder::fqdn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FQDN").build()}).build();
    private static final SdkField<String> IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IAMRoleName").getter(DomainMembership.getter(DomainMembership::iamRoleName)).setter(DomainMembership.setter(Builder::iamRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, STATUS_FIELD, FQDN_FIELD, IAM_ROLE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String status;
    private final String fqdn;
    private final String iamRoleName;

    private DomainMembership(BuilderImpl builder) {
        this.domain = builder.domain;
        this.status = builder.status;
        this.fqdn = builder.fqdn;
        this.iamRoleName = builder.iamRoleName;
    }

    public final String domain() {
        return this.domain;
    }

    public final String status() {
        return this.status;
    }

    public final String fqdn() {
        return this.fqdn;
    }

    public final String iamRoleName() {
        return this.iamRoleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.fqdn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainMembership)) {
            return false;
        }
        DomainMembership other = (DomainMembership)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.fqdn(), other.fqdn()) && Objects.equals(this.iamRoleName(), other.iamRoleName());
    }

    public final String toString() {
        return ToString.builder((String)"DomainMembership").add("Domain", (Object)this.domain()).add("Status", (Object)this.status()).add("FQDN", (Object)this.fqdn()).add("IAMRoleName", (Object)this.iamRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "FQDN": {
                return Optional.ofNullable(clazz.cast(this.fqdn()));
            }
            case "IAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.iamRoleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainMembership, T> g) {
        return obj -> g.apply((DomainMembership)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String status;
        private String fqdn;
        private String iamRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainMembership model) {
            this.domain(model.domain);
            this.status(model.status);
            this.fqdn(model.fqdn);
            this.iamRoleName(model.iamRoleName);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFqdn() {
            return this.fqdn;
        }

        public final void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        @Override
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final String getIamRoleName() {
            return this.iamRoleName;
        }

        public final void setIamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
        }

        @Override
        public final Builder iamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
            return this;
        }

        public DomainMembership build() {
            return new DomainMembership(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainMembership> {
        public Builder domain(String var1);

        public Builder status(String var1);

        public Builder fqdn(String var1);

        public Builder iamRoleName(String var1);
    }
}

