/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.DBCluster;
import software.amazon.awssdk.services.neptune.model.DBClusterListCopier;
import software.amazon.awssdk.services.neptune.model.NeptuneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClustersResponse
extends NeptuneResponse
implements ToCopyableBuilder<Builder, DescribeDbClustersResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbClustersResponse.getter(DescribeDbClustersResponse::marker)).setter(DescribeDbClustersResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBCluster>> DB_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBClusters").getter(DescribeDbClustersResponse.getter(DescribeDbClustersResponse::dbClusters)).setter(DescribeDbClustersResponse.setter(Builder::dbClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusters").build(), ListTrait.builder().memberLocationName("DBCluster").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBCluster").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_CLUSTERS_FIELD));
    private final String marker;
    private final List<DBCluster> dbClusters;

    private DescribeDbClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusters = builder.dbClusters;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasDbClusters() {
        return this.dbClusters != null && !(this.dbClusters instanceof SdkAutoConstructList);
    }

    public final List<DBCluster> dbClusters() {
        return this.dbClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusters() ? this.dbClusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClustersResponse)) {
            return false;
        }
        DescribeDbClustersResponse other = (DescribeDbClustersResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasDbClusters() == other.hasDbClusters() && Objects.equals(this.dbClusters(), other.dbClusters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbClustersResponse").add("Marker", (Object)this.marker()).add("DBClusters", this.hasDbClusters() ? this.dbClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBClusters": {
                return Optional.ofNullable(clazz.cast(this.dbClusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbClustersResponse, T> g) {
        return obj -> g.apply((DescribeDbClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBCluster> dbClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClustersResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusters(model.dbClusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<DBCluster.Builder> getDbClusters() {
            List<DBCluster.Builder> result = DBClusterListCopier.copyToBuilder(this.dbClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusters(Collection<DBCluster.BuilderImpl> dbClusters) {
            this.dbClusters = DBClusterListCopier.copyFromBuilder(dbClusters);
        }

        @Override
        @Transient
        public final Builder dbClusters(Collection<DBCluster> dbClusters) {
            this.dbClusters = DBClusterListCopier.copy(dbClusters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbClusters(DBCluster ... dbClusters) {
            this.dbClusters(Arrays.asList(dbClusters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbClusters(Consumer<DBCluster.Builder> ... dbClusters) {
            this.dbClusters(Stream.of(dbClusters).map(c -> (DBCluster)((DBCluster.Builder)DBCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDbClustersResponse build() {
            return new DescribeDbClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbClustersResponse> {
        public Builder marker(String var1);

        public Builder dbClusters(Collection<DBCluster> var1);

        public Builder dbClusters(DBCluster ... var1);

        public Builder dbClusters(Consumer<DBCluster.Builder> ... var1);
    }
}

