/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.AttributeValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBClusterSnapshotAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBClusterSnapshotAttribute> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(DBClusterSnapshotAttribute.getter(DBClusterSnapshotAttribute::attributeName)).setter(DBClusterSnapshotAttribute.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeValues").getter(DBClusterSnapshotAttribute.getter(DBClusterSnapshotAttribute::attributeValues)).setter(DBClusterSnapshotAttribute.setter(Builder::attributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValues").build(), ListTrait.builder().memberLocationName("AttributeValue").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final List<String> attributeValues;

    private DBClusterSnapshotAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValues = builder.attributeValues;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasAttributeValues() {
        return this.attributeValues != null && !(this.attributeValues instanceof SdkAutoConstructList);
    }

    public final List<String> attributeValues() {
        return this.attributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeValues() ? this.attributeValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterSnapshotAttribute)) {
            return false;
        }
        DBClusterSnapshotAttribute other = (DBClusterSnapshotAttribute)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && this.hasAttributeValues() == other.hasAttributeValues() && Objects.equals(this.attributeValues(), other.attributeValues());
    }

    public final String toString() {
        return ToString.builder((String)"DBClusterSnapshotAttribute").add("AttributeName", (Object)this.attributeName()).add("AttributeValues", this.hasAttributeValues() ? this.attributeValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "AttributeValues": {
                return Optional.ofNullable(clazz.cast(this.attributeValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBClusterSnapshotAttribute, T> g) {
        return obj -> g.apply((DBClusterSnapshotAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private List<String> attributeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterSnapshotAttribute model) {
            this.attributeName(model.attributeName);
            this.attributeValues(model.attributeValues);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        @Transient
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Collection<String> getAttributeValues() {
            if (this.attributeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeValues;
        }

        public final void setAttributeValues(Collection<String> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
        }

        @Override
        @Transient
        public final Builder attributeValues(Collection<String> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributeValues(String ... attributeValues) {
            this.attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        public DBClusterSnapshotAttribute build() {
            return new DBClusterSnapshotAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBClusterSnapshotAttribute> {
        public Builder attributeName(String var1);

        public Builder attributeValues(Collection<String> var1);

        public Builder attributeValues(String ... var1);
    }
}

