/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.neptune.model.DBParameterGroup;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse;

public class DescribeDBParameterGroupsIterable
implements SdkIterable<DescribeDbParameterGroupsResponse> {
    private final NeptuneClient client;
    private final DescribeDbParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBParameterGroupsIterable(NeptuneClient client, DescribeDbParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeDbParameterGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBParameterGroup> dbParameterGroups() {
        Function<DescribeDbParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbParameterGroups() != null) {
                return response.dbParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbParameterGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDbParameterGroupsResponse> {
        private DescribeDbParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbParameterGroupsResponse nextPage(DescribeDbParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParameterGroupsIterable.this.client.describeDBParameterGroups(DescribeDBParameterGroupsIterable.this.firstRequest);
            }
            return DescribeDBParameterGroupsIterable.this.client.describeDBParameterGroups((DescribeDbParameterGroupsRequest)((Object)DescribeDBParameterGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

