/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptune.model.NeptuneRequest;
import software.amazon.awssdk.services.neptune.model.Parameter;
import software.amazon.awssdk.services.neptune.model.ParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbClusterParameterGroupRequest
extends NeptuneRequest
implements ToCopyableBuilder<Builder, ModifyDbClusterParameterGroupRequest> {
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroupName").getter(ModifyDbClusterParameterGroupRequest.getter(ModifyDbClusterParameterGroupRequest::dbClusterParameterGroupName)).setter(ModifyDbClusterParameterGroupRequest.setter(Builder::dbClusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(ModifyDbClusterParameterGroupRequest.getter(ModifyDbClusterParameterGroupRequest::parameters)).setter(ModifyDbClusterParameterGroupRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName("Parameter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, PARAMETERS_FIELD));
    private final String dbClusterParameterGroupName;
    private final List<Parameter> parameters;

    private ModifyDbClusterParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.parameters = builder.parameters;
    }

    public String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterParameterGroupRequest)) {
            return false;
        }
        ModifyDbClusterParameterGroupRequest other = (ModifyDbClusterParameterGroupRequest)((Object)obj);
        return Objects.equals(this.dbClusterParameterGroupName(), other.dbClusterParameterGroupName()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"ModifyDbClusterParameterGroupRequest").add("DBClusterParameterGroupName", (Object)this.dbClusterParameterGroupName()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroupName()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterParameterGroupRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterParameterGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneRequest.BuilderImpl
    implements Builder {
        private String dbClusterParameterGroupName;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterParameterGroupRequest model) {
            super(model);
            this.dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.parameters(model.parameters);
        }

        public final String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterParameterGroupRequest build() {
            return new ModifyDbClusterParameterGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptuneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbClusterParameterGroupRequest> {
        public Builder dbClusterParameterGroupName(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

