/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The version of the database engine that a DB instance can be upgraded to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpgradeTarget implements SdkPojo, Serializable, ToCopyableBuilder<UpgradeTarget.Builder, UpgradeTarget> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpgradeTarget::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpgradeTarget::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpgradeTarget::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Boolean> AUTO_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpgradeTarget::autoUpgrade)).setter(setter(Builder::autoUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpgrade").build()).build();

    private static final SdkField<Boolean> IS_MAJOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpgradeTarget::isMajorVersionUpgrade)).setter(setter(Builder::isMajorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsMajorVersionUpgrade").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DESCRIPTION_FIELD, AUTO_UPGRADE_FIELD, IS_MAJOR_VERSION_UPGRADE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engine;

    private final String engineVersion;

    private final String description;

    private final Boolean autoUpgrade;

    private final Boolean isMajorVersionUpgrade;

    private UpgradeTarget(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.description = builder.description;
        this.autoUpgrade = builder.autoUpgrade;
        this.isMajorVersionUpgrade = builder.isMajorVersionUpgrade;
    }

    /**
     * <p>
     * The name of the upgrade target database engine.
     * </p>
     * 
     * @return The name of the upgrade target database engine.
     */
    public String engine() {
        return engine;
    }

    /**
     * <p>
     * The version number of the upgrade target database engine.
     * </p>
     * 
     * @return The version number of the upgrade target database engine.
     */
    public String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The version of the database engine that a DB instance can be upgraded to.
     * </p>
     * 
     * @return The version of the database engine that a DB instance can be upgraded to.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * A value that indicates whether the target version is applied to any source DB instances that have
     * AutoMinorVersionUpgrade set to true.
     * </p>
     * 
     * @return A value that indicates whether the target version is applied to any source DB instances that have
     *         AutoMinorVersionUpgrade set to true.
     */
    public Boolean autoUpgrade() {
        return autoUpgrade;
    }

    /**
     * <p>
     * A value that indicates whether a database engine is upgraded to a major version.
     * </p>
     * 
     * @return A value that indicates whether a database engine is upgraded to a major version.
     */
    public Boolean isMajorVersionUpgrade() {
        return isMajorVersionUpgrade;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(autoUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(isMajorVersionUpgrade());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeTarget)) {
            return false;
        }
        UpgradeTarget other = (UpgradeTarget) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(description(), other.description()) && Objects.equals(autoUpgrade(), other.autoUpgrade())
                && Objects.equals(isMajorVersionUpgrade(), other.isMajorVersionUpgrade());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpgradeTarget").add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("Description", description()).add("AutoUpgrade", autoUpgrade())
                .add("IsMajorVersionUpgrade", isMajorVersionUpgrade()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AutoUpgrade":
            return Optional.ofNullable(clazz.cast(autoUpgrade()));
        case "IsMajorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(isMajorVersionUpgrade()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeTarget, T> g) {
        return obj -> g.apply((UpgradeTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpgradeTarget> {
        /**
         * <p>
         * The name of the upgrade target database engine.
         * </p>
         * 
         * @param engine
         *        The name of the upgrade target database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The version number of the upgrade target database engine.
         * </p>
         * 
         * @param engineVersion
         *        The version number of the upgrade target database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The version of the database engine that a DB instance can be upgraded to.
         * </p>
         * 
         * @param description
         *        The version of the database engine that a DB instance can be upgraded to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A value that indicates whether the target version is applied to any source DB instances that have
         * AutoMinorVersionUpgrade set to true.
         * </p>
         * 
         * @param autoUpgrade
         *        A value that indicates whether the target version is applied to any source DB instances that have
         *        AutoMinorVersionUpgrade set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoUpgrade(Boolean autoUpgrade);

        /**
         * <p>
         * A value that indicates whether a database engine is upgraded to a major version.
         * </p>
         * 
         * @param isMajorVersionUpgrade
         *        A value that indicates whether a database engine is upgraded to a major version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMajorVersionUpgrade(Boolean isMajorVersionUpgrade);
    }

    static final class BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String description;

        private Boolean autoUpgrade;

        private Boolean isMajorVersionUpgrade;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeTarget model) {
            engine(model.engine);
            engineVersion(model.engineVersion);
            description(model.description);
            autoUpgrade(model.autoUpgrade);
            isMajorVersionUpgrade(model.isMajorVersionUpgrade);
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getAutoUpgrade() {
            return autoUpgrade;
        }

        @Override
        public final Builder autoUpgrade(Boolean autoUpgrade) {
            this.autoUpgrade = autoUpgrade;
            return this;
        }

        public final void setAutoUpgrade(Boolean autoUpgrade) {
            this.autoUpgrade = autoUpgrade;
        }

        public final Boolean getIsMajorVersionUpgrade() {
            return isMajorVersionUpgrade;
        }

        @Override
        public final Builder isMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
            this.isMajorVersionUpgrade = isMajorVersionUpgrade;
            return this;
        }

        public final void setIsMajorVersionUpgrade(Boolean isMajorVersionUpgrade) {
            this.isMajorVersionUpgrade = isMajorVersionUpgrade;
        }

        @Override
        public UpgradeTarget build() {
            return new UpgradeTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
