/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Active Directory Domain membership record associated with a DB instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainMembership.Builder, DomainMembership> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainMembership::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainMembership::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FQDN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainMembership::fqdn)).setter(setter(Builder::fqdn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FQDN").build()).build();

    private static final SdkField<String> IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainMembership::iamRoleName)).setter(setter(Builder::iamRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, STATUS_FIELD,
            FQDN_FIELD, IAM_ROLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String status;

    private final String fqdn;

    private final String iamRoleName;

    private DomainMembership(BuilderImpl builder) {
        this.domain = builder.domain;
        this.status = builder.status;
        this.fqdn = builder.fqdn;
        this.iamRoleName = builder.iamRoleName;
    }

    /**
     * <p>
     * The identifier of the Active Directory Domain.
     * </p>
     * 
     * @return The identifier of the Active Directory Domain.
     */
    public String domain() {
        return domain;
    }

    /**
     * <p>
     * The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed etc).
     * </p>
     * 
     * @return The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed
     *         etc).
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The fully qualified domain name of the Active Directory Domain.
     * </p>
     * 
     * @return The fully qualified domain name of the Active Directory Domain.
     */
    public String fqdn() {
        return fqdn;
    }

    /**
     * <p>
     * The name of the IAM role to be used when making API calls to the Directory Service.
     * </p>
     * 
     * @return The name of the IAM role to be used when making API calls to the Directory Service.
     */
    public String iamRoleName() {
        return iamRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(fqdn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainMembership)) {
            return false;
        }
        DomainMembership other = (DomainMembership) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(status(), other.status())
                && Objects.equals(fqdn(), other.fqdn()) && Objects.equals(iamRoleName(), other.iamRoleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainMembership").add("Domain", domain()).add("Status", status()).add("FQDN", fqdn())
                .add("IAMRoleName", iamRoleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "FQDN":
            return Optional.ofNullable(clazz.cast(fqdn()));
        case "IAMRoleName":
            return Optional.ofNullable(clazz.cast(iamRoleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainMembership, T> g) {
        return obj -> g.apply((DomainMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainMembership> {
        /**
         * <p>
         * The identifier of the Active Directory Domain.
         * </p>
         * 
         * @param domain
         *        The identifier of the Active Directory Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The status of the DB instance's Active Directory Domain membership, such as joined, pending-join, failed
         * etc).
         * </p>
         * 
         * @param status
         *        The status of the DB instance's Active Directory Domain membership, such as joined, pending-join,
         *        failed etc).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The fully qualified domain name of the Active Directory Domain.
         * </p>
         * 
         * @param fqdn
         *        The fully qualified domain name of the Active Directory Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fqdn(String fqdn);

        /**
         * <p>
         * The name of the IAM role to be used when making API calls to the Directory Service.
         * </p>
         * 
         * @param iamRoleName
         *        The name of the IAM role to be used when making API calls to the Directory Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleName(String iamRoleName);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String status;

        private String fqdn;

        private String iamRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainMembership model) {
            domain(model.domain);
            status(model.status);
            fqdn(model.fqdn);
            iamRoleName(model.iamRoleName);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFqdn() {
            return fqdn;
        }

        @Override
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        public final String getIamRoleName() {
            return iamRoleName;
        }

        @Override
        public final Builder iamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
            return this;
        }

        public final void setIamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
        }

        @Override
        public DomainMembership build() {
            return new DomainMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
