/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies membership in a designated DB security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBSecurityGroupMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<DBSecurityGroupMembership.Builder, DBSecurityGroupMembership> {
    private static final SdkField<String> DB_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBSecurityGroupMembership::dbSecurityGroupName)).setter(setter(Builder::dbSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DBSecurityGroupMembership::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SECURITY_GROUP_NAME_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbSecurityGroupName;

    private final String status;

    private DBSecurityGroupMembership(BuilderImpl builder) {
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the DB security group.
     * </p>
     * 
     * @return The name of the DB security group.
     */
    public String dbSecurityGroupName() {
        return dbSecurityGroupName;
    }

    /**
     * <p>
     * The status of the DB security group.
     * </p>
     * 
     * @return The status of the DB security group.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSecurityGroupMembership)) {
            return false;
        }
        DBSecurityGroupMembership other = (DBSecurityGroupMembership) obj;
        return Objects.equals(dbSecurityGroupName(), other.dbSecurityGroupName()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DBSecurityGroupMembership").add("DBSecurityGroupName", dbSecurityGroupName())
                .add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBSecurityGroupName":
            return Optional.ofNullable(clazz.cast(dbSecurityGroupName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBSecurityGroupMembership, T> g) {
        return obj -> g.apply((DBSecurityGroupMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBSecurityGroupMembership> {
        /**
         * <p>
         * The name of the DB security group.
         * </p>
         * 
         * @param dbSecurityGroupName
         *        The name of the DB security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupName(String dbSecurityGroupName);

        /**
         * <p>
         * The status of the DB security group.
         * </p>
         * 
         * @param status
         *        The status of the DB security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String dbSecurityGroupName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSecurityGroupMembership model) {
            dbSecurityGroupName(model.dbSecurityGroupName);
            status(model.status);
        }

        public final String getDbSecurityGroupName() {
            return dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final void setDbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DBSecurityGroupMembership build() {
            return new DBSecurityGroupMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
