/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptune;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.neptune.NeptuneClient;
import software.amazon.awssdk.services.neptune.model.AddRoleToDBClusterResponse;
import software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.neptune.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.neptune.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.neptune.model.CertificateNotFoundException;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbClusterRoleQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.neptune.model.DeleteDBClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDBParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDBSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeEventsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeEventsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.neptune.model.DomainNotFoundException;
import software.amazon.awssdk.services.neptune.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.neptune.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.neptune.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.neptune.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.neptune.model.InvalidEventSubscriptionStateException;
import software.amazon.awssdk.services.neptune.model.InvalidRestoreException;
import software.amazon.awssdk.services.neptune.model.InvalidSubnetException;
import software.amazon.awssdk.services.neptune.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.neptune.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptune.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.NeptuneException;
import software.amazon.awssdk.services.neptune.model.NeptuneRequest;
import software.amazon.awssdk.services.neptune.model.OptionGroupNotFoundException;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.ProvisionedIopsNotAvailableInAzException;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDBClusterResponse;
import software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.neptune.model.ResourceNotFoundException;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.neptune.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.neptune.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.neptune.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.neptune.model.SourceNotFoundException;
import software.amazon.awssdk.services.neptune.model.StartDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StartDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StopDbClusterRequest;
import software.amazon.awssdk.services.neptune.model.StopDbClusterResponse;
import software.amazon.awssdk.services.neptune.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.neptune.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.neptune.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.neptune.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.neptune.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.neptune.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBEngineVersionsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBInstancesIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParameterGroupsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBParametersIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeDBSubnetGroupsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeEngineDefaultParametersIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.neptune.paginators.DescribeOrderableDBInstanceOptionsIterable;
import software.amazon.awssdk.services.neptune.transform.AddRoleToDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.AddSourceIdentifierToSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CopyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterSnapshotAttributesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbClustersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbEngineVersionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbInstancesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbParameterGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeDbSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEngineDefaultClusterParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEngineDefaultParametersRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeOrderableDbInstanceOptionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.DescribeValidDbInstanceModificationsRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.FailoverDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbClusterSnapshotAttributeRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyDbSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.PromoteReadReplicaDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RebootDbInstanceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveRoleFromDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveSourceIdentifierFromSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ResetDbClusterParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.ResetDbParameterGroupRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RestoreDbClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.RestoreDbClusterToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.StartDbClusterRequestMarshaller;
import software.amazon.awssdk.services.neptune.transform.StopDbClusterRequestMarshaller;

@SdkInternalApi
final class DefaultNeptuneClient
implements NeptuneClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultNeptuneClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "rds";
    }

    @Override
    public AddRoleToDBClusterResponse addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest) throws DbClusterNotFoundException, DbClusterRoleAlreadyExistsException, InvalidDbClusterStateException, DbClusterRoleQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddRoleToDBClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddRoleToDBClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddRoleToDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addRoleToDbClusterRequest).withMarshaller((Marshaller)new AddRoleToDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddSourceIdentifierToSubscriptionResponse addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddSourceIdentifierToSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddSourceIdentifierToSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddSourceIdentifierToSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addSourceIdentifierToSubscriptionRequest).withMarshaller((Marshaller)new AddSourceIdentifierToSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsToResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ApplyPendingMaintenanceActionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ApplyPendingMaintenanceActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplyPendingMaintenanceAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)applyPendingMaintenanceActionRequest).withMarshaller((Marshaller)new ApplyPendingMaintenanceActionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException, DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CopyDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbClusterParameterGroupRequest).withMarshaller((Marshaller)new CopyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CopyDbClusterSnapshotResponse copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest) throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException, InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CopyDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbClusterSnapshotRequest).withMarshaller((Marshaller)new CopyDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CopyDbParameterGroupResponse copyDBParameterGroup(CopyDbParameterGroupRequest copyDbParameterGroupRequest) throws DbParameterGroupNotFoundException, DbParameterGroupAlreadyExistsException, DbParameterGroupQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CopyDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CopyDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyDbParameterGroupRequest).withMarshaller((Marshaller)new CopyDbParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbClusterResponse createDBCluster(CreateDbClusterRequest createDbClusterRequest) throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException, InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException, DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterRequest).withMarshaller((Marshaller)new CreateDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest) throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterParameterGroupRequest).withMarshaller((Marshaller)new CreateDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbClusterSnapshotResponse createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest) throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException, SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbClusterSnapshotRequest).withMarshaller((Marshaller)new CreateDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbInstanceResponse createDBInstance(CreateDbInstanceRequest createDbInstanceRequest) throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException, DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException, InvalidSubnetException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException, DbClusterNotFoundException, StorageTypeNotSupportedException, AuthorizationNotFoundException, KmsKeyNotAccessibleException, DomainNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbInstanceRequest).withMarshaller((Marshaller)new CreateDbInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbParameterGroupResponse createDBParameterGroup(CreateDbParameterGroupRequest createDbParameterGroupRequest) throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbParameterGroupRequest).withMarshaller((Marshaller)new CreateDbParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDbSubnetGroupResponse createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest) throws DbSubnetGroupAlreadyExistsException, DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDbSubnetGroupRequest).withMarshaller((Marshaller)new CreateDbSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException, SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createEventSubscriptionRequest).withMarshaller((Marshaller)new CreateEventSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDbClusterResponse deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException, SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterRequest).withMarshaller((Marshaller)new DeleteDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDBClusterParameterGroupResponse deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDBClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDBClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterParameterGroupRequest).withMarshaller((Marshaller)new DeleteDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest) throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbClusterSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDbClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbClusterSnapshotRequest).withMarshaller((Marshaller)new DeleteDbClusterSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDbInstanceResponse deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest) throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException, SnapshotQuotaExceededException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbInstanceRequest).withMarshaller((Marshaller)new DeleteDbInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDBParameterGroupResponse deleteDBParameterGroup(DeleteDbParameterGroupRequest deleteDbParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDBParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDBParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbParameterGroupRequest).withMarshaller((Marshaller)new DeleteDbParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDBSubnetGroupResponse deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest) throws InvalidDbSubnetGroupStateException, InvalidDbSubnetStateException, DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDBSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDBSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDbSubnetGroupRequest).withMarshaller((Marshaller)new DeleteDbSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) throws SubscriptionNotFoundException, InvalidEventSubscriptionStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventSubscriptionRequest).withMarshaller((Marshaller)new DeleteEventSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParameterGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClusterParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameterGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterParameterGroupsRequest).withMarshaller((Marshaller)new DescribeDbClusterParameterGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClusterParametersResponse describeDBClusterParameters(DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterParametersRequest).withMarshaller((Marshaller)new DescribeDbClusterParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClusterSnapshotAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshotAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterSnapshotAttributesRequest).withMarshaller((Marshaller)new DescribeDbClusterSnapshotAttributesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClusterSnapshotsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClusterSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusterSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClusterSnapshotsRequest).withMarshaller((Marshaller)new DescribeDbClusterSnapshotsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbClustersResponse describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest) throws DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbClustersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbClustersRequest).withMarshaller((Marshaller)new DescribeDbClustersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDbEngineVersionsResponse describeDBEngineVersions(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbEngineVersionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbEngineVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBEngineVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbEngineVersionsRequest).withMarshaller((Marshaller)new DescribeDbEngineVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBEngineVersionsIterable(this, this.applyPaginatorUserAgent(describeDbEngineVersionsRequest));
    }

    @Override
    public DescribeDbInstancesResponse describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest) throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbInstancesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbInstancesRequest).withMarshaller((Marshaller)new DescribeDbInstancesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBInstancesIterable describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest) throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBInstancesIterable(this, this.applyPaginatorUserAgent(describeDbInstancesRequest));
    }

    @Override
    public DescribeDbParameterGroupsResponse describeDBParameterGroups(DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbParameterGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbParameterGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBParameterGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbParameterGroupsRequest).withMarshaller((Marshaller)new DescribeDbParameterGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBParameterGroupsIterable describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBParameterGroupsIterable(this, this.applyPaginatorUserAgent(describeDbParameterGroupsRequest));
    }

    @Override
    public DescribeDbParametersResponse describeDBParameters(DescribeDbParametersRequest describeDbParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbParametersRequest).withMarshaller((Marshaller)new DescribeDbParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBParametersIterable describeDBParametersPaginator(DescribeDbParametersRequest describeDbParametersRequest) throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBParametersIterable(this, this.applyPaginatorUserAgent(describeDbParametersRequest));
    }

    @Override
    public DescribeDbSubnetGroupsResponse describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDbSubnetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDbSubnetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDBSubnetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDbSubnetGroupsRequest).withMarshaller((Marshaller)new DescribeDbSubnetGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeDBSubnetGroupsIterable(this, this.applyPaginatorUserAgent(describeDbSubnetGroupsRequest));
    }

    @Override
    public DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultClusterParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEngineDefaultClusterParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultClusterParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEngineDefaultClusterParametersRequest).withMarshaller((Marshaller)new DescribeEngineDefaultClusterParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEngineDefaultParametersResponse describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEngineDefaultParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEngineDefaultParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEngineDefaultParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEngineDefaultParametersRequest).withMarshaller((Marshaller)new DescribeEngineDefaultParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEngineDefaultParametersIterable describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeEngineDefaultParametersIterable(this, this.applyPaginatorUserAgent(describeEngineDefaultParametersRequest));
    }

    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventCategoriesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventCategories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventCategoriesRequest).withMarshaller((Marshaller)new DescribeEventCategoriesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventSubscriptionsResponse describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventSubscriptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventSubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEventSubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventSubscriptionsRequest).withMarshaller((Marshaller)new DescribeEventSubscriptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeEventSubscriptionsIterable(this, this.applyPaginatorUserAgent(describeEventSubscriptionsRequest));
    }

    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeEventsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeEventsRequest).withMarshaller((Marshaller)new DescribeEventsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeEventsIterable(this, this.applyPaginatorUserAgent(describeEventsRequest));
    }

    @Override
    public DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeOrderableDbInstanceOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeOrderableDbInstanceOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOrderableDBInstanceOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeOrderableDbInstanceOptionsRequest).withMarshaller((Marshaller)new DescribeOrderableDbInstanceOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeOrderableDBInstanceOptionsIterable describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException, SdkClientException, NeptuneException {
        return new DescribeOrderableDBInstanceOptionsIterable(this, this.applyPaginatorUserAgent(describeOrderableDbInstanceOptionsRequest));
    }

    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribePendingMaintenanceActionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribePendingMaintenanceActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePendingMaintenanceActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePendingMaintenanceActionsRequest).withMarshaller((Marshaller)new DescribePendingMaintenanceActionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeValidDbInstanceModificationsResponse describeValidDBInstanceModifications(DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest) throws DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeValidDbInstanceModificationsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeValidDbInstanceModificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeValidDBInstanceModifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeValidDbInstanceModificationsRequest).withMarshaller((Marshaller)new DescribeValidDbInstanceModificationsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public FailoverDbClusterResponse failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(FailoverDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (FailoverDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FailoverDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)failoverDbClusterRequest).withMarshaller((Marshaller)new FailoverDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbClusterResponse modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException, InvalidDbInstanceStateException, DbClusterAlreadyExistsException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterRequest).withMarshaller((Marshaller)new ModifyDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterParameterGroupRequest).withMarshaller((Marshaller)new ModifyDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest) throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException, SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbClusterSnapshotAttributeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbClusterSnapshotAttributeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBClusterSnapshotAttribute").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbClusterSnapshotAttributeRequest).withMarshaller((Marshaller)new ModifyDbClusterSnapshotAttributeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbInstanceResponse modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest) throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException, DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException, InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException, DbUpgradeDependencyFailureException, StorageTypeNotSupportedException, AuthorizationNotFoundException, CertificateNotFoundException, DomainNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbInstanceRequest).withMarshaller((Marshaller)new ModifyDbInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbParameterGroupResponse modifyDBParameterGroup(ModifyDbParameterGroupRequest modifyDbParameterGroupRequest) throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbParameterGroupRequest).withMarshaller((Marshaller)new ModifyDbParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyDbSubnetGroupResponse modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest) throws DbSubnetGroupNotFoundException, DbSubnetQuotaExceededException, SubnetAlreadyInUseException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyDbSubnetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyDbSubnetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyDBSubnetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyDbSubnetGroupRequest).withMarshaller((Marshaller)new ModifyDbSubnetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) throws EventSubscriptionQuotaExceededException, SubscriptionNotFoundException, SnsInvalidTopicException, SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyEventSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ModifyEventSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyEventSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyEventSubscriptionRequest).withMarshaller((Marshaller)new ModifyEventSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PromoteReadReplicaDbClusterResponse promoteReadReplicaDBCluster(PromoteReadReplicaDbClusterRequest promoteReadReplicaDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PromoteReadReplicaDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (PromoteReadReplicaDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PromoteReadReplicaDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)promoteReadReplicaDbClusterRequest).withMarshaller((Marshaller)new PromoteReadReplicaDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RebootDbInstanceResponse rebootDBInstance(RebootDbInstanceRequest rebootDbInstanceRequest) throws InvalidDbInstanceStateException, DbInstanceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RebootDbInstanceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RebootDbInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootDBInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rebootDbInstanceRequest).withMarshaller((Marshaller)new RebootDbInstanceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveRoleFromDBClusterResponse removeRoleFromDBCluster(RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest) throws DbClusterNotFoundException, DbClusterRoleNotFoundException, InvalidDbClusterStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveRoleFromDBClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemoveRoleFromDBClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveRoleFromDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeRoleFromDbClusterRequest).withMarshaller((Marshaller)new RemoveRoleFromDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveSourceIdentifierFromSubscriptionResponse removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest) throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveSourceIdentifierFromSubscriptionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemoveSourceIdentifierFromSubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveSourceIdentifierFromSubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeSourceIdentifierFromSubscriptionRequest).withMarshaller((Marshaller)new RemoveSourceIdentifierFromSubscriptionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsFromResourceResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ResetDbClusterParameterGroupResponse resetDBClusterParameterGroup(ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbClusterParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ResetDbClusterParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBClusterParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetDbClusterParameterGroupRequest).withMarshaller((Marshaller)new ResetDbClusterParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ResetDbParameterGroupResponse resetDBParameterGroup(ResetDbParameterGroupRequest resetDbParameterGroupRequest) throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ResetDbParameterGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ResetDbParameterGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResetDBParameterGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resetDbParameterGroupRequest).withMarshaller((Marshaller)new ResetDbParameterGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RestoreDbClusterFromSnapshotResponse restoreDBClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) throws DbClusterAlreadyExistsException, DbClusterQuotaExceededException, StorageQuotaExceededException, DbSubnetGroupNotFoundException, DbSnapshotNotFoundException, DbClusterSnapshotNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbSnapshotStateException, InvalidDbClusterSnapshotStateException, InvalidVpcNetworkStateException, InvalidRestoreException, InvalidSubnetException, OptionGroupNotFoundException, KmsKeyNotAccessibleException, DbClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterFromSnapshotResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RestoreDbClusterFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDbClusterFromSnapshotRequest).withMarshaller((Marshaller)new RestoreDbClusterFromSnapshotRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RestoreDbClusterToPointInTimeResponse restoreDBClusterToPointInTime(RestoreDbClusterToPointInTimeRequest restoreDbClusterToPointInTimeRequest) throws DbClusterAlreadyExistsException, DbClusterNotFoundException, DbClusterQuotaExceededException, DbClusterSnapshotNotFoundException, DbSubnetGroupNotFoundException, InsufficientDbClusterCapacityException, InsufficientStorageClusterCapacityException, InvalidDbClusterSnapshotStateException, InvalidDbClusterStateException, InvalidDbSnapshotStateException, InvalidRestoreException, InvalidSubnetException, InvalidVpcNetworkStateException, KmsKeyNotAccessibleException, OptionGroupNotFoundException, StorageQuotaExceededException, DbClusterParameterGroupNotFoundException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RestoreDbClusterToPointInTimeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (RestoreDbClusterToPointInTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDBClusterToPointInTime").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDbClusterToPointInTimeRequest).withMarshaller((Marshaller)new RestoreDbClusterToPointInTimeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StartDbClusterResponse startDBCluster(StartDbClusterRequest startDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (StartDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startDbClusterRequest).withMarshaller((Marshaller)new StartDbClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public StopDbClusterResponse stopDBCluster(StopDbClusterRequest stopDbClusterRequest) throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, NeptuneException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StopDbClusterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (StopDbClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDBCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)stopDbClusterRequest).withMarshaller((Marshaller)new StopDbClusterRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupNotFound").exceptionBuilderSupplier(DbParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterQuotaExceededFault").exceptionBuilderSupplier(DbClusterQuotaExceededException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleNotFound").exceptionBuilderSupplier(DbClusterRoleNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionCategoryNotFound").exceptionBuilderSupplier(SubscriptionCategoryNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestoreFault").exceptionBuilderSupplier(InvalidRestoreException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBClusterCapacityFault").exceptionBuilderSupplier(InsufficientDbClusterCapacityException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceNotFound").exceptionBuilderSupplier(DbInstanceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupDoesNotCoverEnoughAZs").exceptionBuilderSupplier(DbSubnetGroupDoesNotCoverEnoughAZsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupQuotaExceeded").exceptionBuilderSupplier(DbSubnetGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault").exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleQuotaExceeded").exceptionBuilderSupplier(DbClusterRoleQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCNetworkStateFault").exceptionBuilderSupplier(InvalidVpcNetworkStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSecurityGroupState").exceptionBuilderSupplier(InvalidDbSecurityGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundFault").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupQuotaExceeded").exceptionBuilderSupplier(DbParameterGroupQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageTypeNotSupported").exceptionBuilderSupplier(StorageTypeNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionNotFound").exceptionBuilderSupplier(SubscriptionNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientStorageClusterCapacity").exceptionBuilderSupplier(InsufficientStorageClusterCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBInstanceAlreadyExists").exceptionBuilderSupplier(DbInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse").exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupAlreadyExists").exceptionBuilderSupplier(DbSubnetGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterAlreadyExistsFault").exceptionBuilderSupplier(DbClusterAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterRoleAlreadyExists").exceptionBuilderSupplier(DbClusterRoleAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidEventSubscriptionState").exceptionBuilderSupplier(InvalidEventSubscriptionStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSnapshotState").exceptionBuilderSupplier(InvalidDbSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSTopicArnNotFound").exceptionBuilderSupplier(SnsTopicArnNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InstanceQuotaExceeded").exceptionBuilderSupplier(InstanceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterNotFoundFault").exceptionBuilderSupplier(DbClusterNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SnapshotQuotaExceeded").exceptionBuilderSupplier(SnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetStateFault").exceptionBuilderSupplier(InvalidDbSubnetStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SharedSnapshotQuotaExceeded").exceptionBuilderSupplier(SharedSnapshotQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotAlreadyExists").exceptionBuilderSupplier(DbSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotAlreadyExistsFault").exceptionBuilderSupplier(DbClusterSnapshotAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterStateFault").exceptionBuilderSupplier(InvalidDbClusterStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBSubnetGroupStateFault").exceptionBuilderSupplier(InvalidDbSubnetGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterParameterGroupNotFound").exceptionBuilderSupplier(DbClusterParameterGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetQuotaExceededFault").exceptionBuilderSupplier(DbSubnetQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSInvalidTopic").exceptionBuilderSupplier(SnsInvalidTopicException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSubnetGroupNotFoundFault").exceptionBuilderSupplier(DbSubnetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBUpgradeDependencyFailure").exceptionBuilderSupplier(DbUpgradeDependencyFailureException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedIopsNotAvailableInAZFault").exceptionBuilderSupplier(ProvisionedIopsNotAvailableInAzException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBClusterSnapshotStateFault").exceptionBuilderSupplier(InvalidDbClusterSnapshotStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSecurityGroupNotFound").exceptionBuilderSupplier(DbSecurityGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientDBInstanceCapacity").exceptionBuilderSupplier(InsufficientDbInstanceCapacityException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBParameterGroupAlreadyExists").exceptionBuilderSupplier(DbParameterGroupAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SNSNoAuthorization").exceptionBuilderSupplier(SnsNoAuthorizationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBSnapshotNotFound").exceptionBuilderSupplier(DbSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubscriptionAlreadyExist").exceptionBuilderSupplier(SubscriptionAlreadyExistException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OptionGroupNotFoundFault").exceptionBuilderSupplier(OptionGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DBClusterSnapshotNotFoundFault").exceptionBuilderSupplier(DbClusterSnapshotNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SourceNotFound").exceptionBuilderSupplier(SourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBInstanceState").exceptionBuilderSupplier(InvalidDbInstanceStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainNotFoundFault").exceptionBuilderSupplier(DomainNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EventSubscriptionQuotaExceeded").exceptionBuilderSupplier(EventSubscriptionQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StorageQuotaExceeded").exceptionBuilderSupplier(StorageQuotaExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDBParameterGroupState").exceptionBuilderSupplier(InvalidDbParameterGroupStateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AuthorizationNotFound").exceptionBuilderSupplier(AuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(NeptuneException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends NeptuneRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.11.4").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((NeptuneRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

