/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeValidDbInstanceModificationsResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeValidDbInstanceModificationsResponse.Builder, DescribeValidDbInstanceModificationsResponse> {
    private static final SdkField<ValidDBInstanceModificationsMessage> VALID_DB_INSTANCE_MODIFICATIONS_MESSAGE_FIELD = SdkField
            .<ValidDBInstanceModificationsMessage> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeValidDbInstanceModificationsResponse::validDBInstanceModificationsMessage))
            .setter(setter(Builder::validDBInstanceModificationsMessage))
            .constructor(ValidDBInstanceModificationsMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ValidDBInstanceModificationsMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(VALID_DB_INSTANCE_MODIFICATIONS_MESSAGE_FIELD));

    private final ValidDBInstanceModificationsMessage validDBInstanceModificationsMessage;

    private DescribeValidDbInstanceModificationsResponse(BuilderImpl builder) {
        super(builder);
        this.validDBInstanceModificationsMessage = builder.validDBInstanceModificationsMessage;
    }

    /**
     * Returns the value of the ValidDBInstanceModificationsMessage property for this object.
     * 
     * @return The value of the ValidDBInstanceModificationsMessage property for this object.
     */
    public ValidDBInstanceModificationsMessage validDBInstanceModificationsMessage() {
        return validDBInstanceModificationsMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(validDBInstanceModificationsMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeValidDbInstanceModificationsResponse)) {
            return false;
        }
        DescribeValidDbInstanceModificationsResponse other = (DescribeValidDbInstanceModificationsResponse) obj;
        return Objects.equals(validDBInstanceModificationsMessage(), other.validDBInstanceModificationsMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeValidDbInstanceModificationsResponse")
                .add("ValidDBInstanceModificationsMessage", validDBInstanceModificationsMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValidDBInstanceModificationsMessage":
            return Optional.ofNullable(clazz.cast(validDBInstanceModificationsMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeValidDbInstanceModificationsResponse, T> g) {
        return obj -> g.apply((DescribeValidDbInstanceModificationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeValidDbInstanceModificationsResponse> {
        /**
         * Sets the value of the ValidDBInstanceModificationsMessage property for this object.
         *
         * @param validDBInstanceModificationsMessage
         *        The new value for the ValidDBInstanceModificationsMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validDBInstanceModificationsMessage(ValidDBInstanceModificationsMessage validDBInstanceModificationsMessage);

        /**
         * Sets the value of the ValidDBInstanceModificationsMessage property for this object.
         *
         * This is a convenience that creates an instance of the {@link ValidDBInstanceModificationsMessage.Builder}
         * avoiding the need to create one manually via {@link ValidDBInstanceModificationsMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ValidDBInstanceModificationsMessage.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #validDBInstanceModificationsMessage(ValidDBInstanceModificationsMessage)}.
         * 
         * @param validDBInstanceModificationsMessage
         *        a consumer that will call methods on {@link ValidDBInstanceModificationsMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validDBInstanceModificationsMessage(ValidDBInstanceModificationsMessage)
         */
        default Builder validDBInstanceModificationsMessage(
                Consumer<ValidDBInstanceModificationsMessage.Builder> validDBInstanceModificationsMessage) {
            return validDBInstanceModificationsMessage(ValidDBInstanceModificationsMessage.builder()
                    .applyMutation(validDBInstanceModificationsMessage).build());
        }
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private ValidDBInstanceModificationsMessage validDBInstanceModificationsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeValidDbInstanceModificationsResponse model) {
            super(model);
            validDBInstanceModificationsMessage(model.validDBInstanceModificationsMessage);
        }

        public final ValidDBInstanceModificationsMessage.Builder getValidDBInstanceModificationsMessage() {
            return validDBInstanceModificationsMessage != null ? validDBInstanceModificationsMessage.toBuilder() : null;
        }

        @Override
        public final Builder validDBInstanceModificationsMessage(
                ValidDBInstanceModificationsMessage validDBInstanceModificationsMessage) {
            this.validDBInstanceModificationsMessage = validDBInstanceModificationsMessage;
            return this;
        }

        public final void setValidDBInstanceModificationsMessage(
                ValidDBInstanceModificationsMessage.BuilderImpl validDBInstanceModificationsMessage) {
            this.validDBInstanceModificationsMessage = validDBInstanceModificationsMessage != null ? validDBInstanceModificationsMessage
                    .build() : null;
        }

        @Override
        public DescribeValidDbInstanceModificationsResponse build() {
            return new DescribeValidDbInstanceModificationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
