/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventCategoriesResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeEventCategoriesResponse.Builder, DescribeEventCategoriesResponse> {
    private static final SdkField<List<EventCategoriesMap>> EVENT_CATEGORIES_MAP_LIST_FIELD = SdkField
            .<List<EventCategoriesMap>> builder(MarshallingType.LIST)
            .getter(getter(DescribeEventCategoriesResponse::eventCategoriesMapList))
            .setter(setter(Builder::eventCategoriesMapList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategoriesMapList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EventCategoriesMap")
                            .memberFieldInfo(
                                    SdkField.<EventCategoriesMap> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventCategoriesMap::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EventCategoriesMap").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EVENT_CATEGORIES_MAP_LIST_FIELD));

    private final List<EventCategoriesMap> eventCategoriesMapList;

    private DescribeEventCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.eventCategoriesMapList = builder.eventCategoriesMapList;
    }

    /**
     * Returns true if the EventCategoriesMapList property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventCategoriesMapList() {
        return eventCategoriesMapList != null && !(eventCategoriesMapList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of EventCategoriesMap data types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventCategoriesMapList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of EventCategoriesMap data types.
     */
    public List<EventCategoriesMap> eventCategoriesMapList() {
        return eventCategoriesMapList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventCategoriesMapList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventCategoriesResponse)) {
            return false;
        }
        DescribeEventCategoriesResponse other = (DescribeEventCategoriesResponse) obj;
        return Objects.equals(eventCategoriesMapList(), other.eventCategoriesMapList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeEventCategoriesResponse").add("EventCategoriesMapList", eventCategoriesMapList())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventCategoriesMapList":
            return Optional.ofNullable(clazz.cast(eventCategoriesMapList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventCategoriesResponse, T> g) {
        return obj -> g.apply((DescribeEventCategoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventCategoriesResponse> {
        /**
         * <p>
         * A list of EventCategoriesMap data types.
         * </p>
         * 
         * @param eventCategoriesMapList
         *        A list of EventCategoriesMap data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategoriesMapList(Collection<EventCategoriesMap> eventCategoriesMapList);

        /**
         * <p>
         * A list of EventCategoriesMap data types.
         * </p>
         * 
         * @param eventCategoriesMapList
         *        A list of EventCategoriesMap data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategoriesMapList(EventCategoriesMap... eventCategoriesMapList);

        /**
         * <p>
         * A list of EventCategoriesMap data types.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventCategoriesMap>.Builder} avoiding the
         * need to create one manually via {@link List<EventCategoriesMap>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventCategoriesMap>.Builder#build()} is called immediately
         * and its result is passed to {@link #eventCategoriesMapList(List<EventCategoriesMap>)}.
         * 
         * @param eventCategoriesMapList
         *        a consumer that will call methods on {@link List<EventCategoriesMap>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventCategoriesMapList(List<EventCategoriesMap>)
         */
        Builder eventCategoriesMapList(Consumer<EventCategoriesMap.Builder>... eventCategoriesMapList);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private List<EventCategoriesMap> eventCategoriesMapList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventCategoriesResponse model) {
            super(model);
            eventCategoriesMapList(model.eventCategoriesMapList);
        }

        public final Collection<EventCategoriesMap.Builder> getEventCategoriesMapList() {
            return eventCategoriesMapList != null ? eventCategoriesMapList.stream().map(EventCategoriesMap::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventCategoriesMapList(Collection<EventCategoriesMap> eventCategoriesMapList) {
            this.eventCategoriesMapList = EventCategoriesMapListCopier.copy(eventCategoriesMapList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesMapList(EventCategoriesMap... eventCategoriesMapList) {
            eventCategoriesMapList(Arrays.asList(eventCategoriesMapList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesMapList(Consumer<EventCategoriesMap.Builder>... eventCategoriesMapList) {
            eventCategoriesMapList(Stream.of(eventCategoriesMapList)
                    .map(c -> EventCategoriesMap.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventCategoriesMapList(Collection<EventCategoriesMap.BuilderImpl> eventCategoriesMapList) {
            this.eventCategoriesMapList = EventCategoriesMapListCopier.copyFromBuilder(eventCategoriesMapList);
        }

        @Override
        public DescribeEventCategoriesResponse build() {
            return new DescribeEventCategoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
