/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mwaaserverless.model.MwaaServerlessResponse;
import software.amazon.awssdk.services.mwaaserverless.model.ObjectMapCopier;
import software.amazon.awssdk.services.mwaaserverless.model.RunType;
import software.amazon.awssdk.services.mwaaserverless.model.WorkflowRunDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowRunResponse
extends MwaaServerlessResponse
implements ToCopyableBuilder<Builder, GetWorkflowRunResponse> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowArn").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::workflowArn)).setter(GetWorkflowRunResponse.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()}).build();
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowVersion").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::workflowVersion)).setter(GetWorkflowRunResponse.setter(Builder::workflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::runId)).setter(GetWorkflowRunResponse.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<String> RUN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunType").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::runTypeAsString)).setter(GetWorkflowRunResponse.setter(Builder::runType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunType").build()}).build();
    private static final SdkField<Map<String, Document>> OVERRIDE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OverrideParameters").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::overrideParameters)).setter(GetWorkflowRunResponse.setter(Builder::overrideParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<WorkflowRunDetail> RUN_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunDetail").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::runDetail)).setter(GetWorkflowRunResponse.setter(Builder::runDetail)).constructor(WorkflowRunDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD, WORKFLOW_VERSION_FIELD, RUN_ID_FIELD, RUN_TYPE_FIELD, OVERRIDE_PARAMETERS_FIELD, RUN_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowRunResponse.memberNameToFieldInitializer();
    private final String workflowArn;
    private final String workflowVersion;
    private final String runId;
    private final String runType;
    private final Map<String, Document> overrideParameters;
    private final WorkflowRunDetail runDetail;

    private GetWorkflowRunResponse(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.workflowVersion = builder.workflowVersion;
        this.runId = builder.runId;
        this.runType = builder.runType;
        this.overrideParameters = builder.overrideParameters;
        this.runDetail = builder.runDetail;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String workflowVersion() {
        return this.workflowVersion;
    }

    public final String runId() {
        return this.runId;
    }

    public final RunType runType() {
        return RunType.fromValue(this.runType);
    }

    public final String runTypeAsString() {
        return this.runType;
    }

    public final boolean hasOverrideParameters() {
        return this.overrideParameters != null && !(this.overrideParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> overrideParameters() {
        return this.overrideParameters;
    }

    public final WorkflowRunDetail runDetail() {
        return this.runDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrideParameters() ? this.overrideParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunResponse)) {
            return false;
        }
        GetWorkflowRunResponse other = (GetWorkflowRunResponse)((Object)obj);
        return Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.workflowVersion(), other.workflowVersion()) && Objects.equals(this.runId(), other.runId()) && Objects.equals(this.runTypeAsString(), other.runTypeAsString()) && this.hasOverrideParameters() == other.hasOverrideParameters() && Objects.equals(this.overrideParameters(), other.overrideParameters()) && Objects.equals(this.runDetail(), other.runDetail());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowRunResponse").add("WorkflowArn", (Object)this.workflowArn()).add("WorkflowVersion", (Object)this.workflowVersion()).add("RunId", (Object)this.runId()).add("RunType", (Object)this.runTypeAsString()).add("OverrideParameters", (Object)(this.overrideParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("RunDetail", (Object)this.runDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "WorkflowVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowVersion()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "RunType": {
                return Optional.ofNullable(clazz.cast(this.runTypeAsString()));
            }
            case "OverrideParameters": {
                return Optional.ofNullable(clazz.cast(this.overrideParameters()));
            }
            case "RunDetail": {
                return Optional.ofNullable(clazz.cast(this.runDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        map.put("RunId", RUN_ID_FIELD);
        map.put("RunType", RUN_TYPE_FIELD);
        map.put("OverrideParameters", OVERRIDE_PARAMETERS_FIELD);
        map.put("RunDetail", RUN_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunResponse, T> g) {
        return obj -> g.apply((GetWorkflowRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaServerlessResponse.BuilderImpl
    implements Builder {
        private String workflowArn;
        private String workflowVersion;
        private String runId;
        private String runType;
        private Map<String, Document> overrideParameters = DefaultSdkAutoConstructMap.getInstance();
        private WorkflowRunDetail runDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunResponse model) {
            super(model);
            this.workflowArn(model.workflowArn);
            this.workflowVersion(model.workflowVersion);
            this.runId(model.runId);
            this.runType(model.runType);
            this.overrideParameters(model.overrideParameters);
            this.runDetail(model.runDetail);
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getWorkflowVersion() {
            return this.workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getRunType() {
            return this.runType;
        }

        public final void setRunType(String runType) {
            this.runType = runType;
        }

        @Override
        public final Builder runType(String runType) {
            this.runType = runType;
            return this;
        }

        @Override
        public final Builder runType(RunType runType) {
            this.runType(runType == null ? null : runType.toString());
            return this;
        }

        public final Map<String, Document> getOverrideParameters() {
            if (this.overrideParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.overrideParameters;
        }

        public final void setOverrideParameters(Map<String, Document> overrideParameters) {
            this.overrideParameters = ObjectMapCopier.copy(overrideParameters);
        }

        @Override
        public final Builder overrideParameters(Map<String, Document> overrideParameters) {
            this.overrideParameters = ObjectMapCopier.copy(overrideParameters);
            return this;
        }

        public final WorkflowRunDetail.Builder getRunDetail() {
            return this.runDetail != null ? this.runDetail.toBuilder() : null;
        }

        public final void setRunDetail(WorkflowRunDetail.BuilderImpl runDetail) {
            this.runDetail = runDetail != null ? runDetail.build() : null;
        }

        @Override
        public final Builder runDetail(WorkflowRunDetail runDetail) {
            this.runDetail = runDetail;
            return this;
        }

        @Override
        public GetWorkflowRunResponse build() {
            return new GetWorkflowRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowRunResponse> {
        public Builder workflowArn(String var1);

        public Builder workflowVersion(String var1);

        public Builder runId(String var1);

        public Builder runType(String var1);

        public Builder runType(RunType var1);

        public Builder overrideParameters(Map<String, Document> var1);

        public Builder runDetail(WorkflowRunDetail var1);

        default public Builder runDetail(Consumer<WorkflowRunDetail.Builder> runDetail) {
            return this.runDetail((WorkflowRunDetail)((WorkflowRunDetail.Builder)WorkflowRunDetail.builder().applyMutation(runDetail)).build());
        }
    }
}

