/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mwaaserverless.model.MwaaServerlessRequest;
import software.amazon.awssdk.services.mwaaserverless.model.ObjectMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartWorkflowRunRequest
extends MwaaServerlessRequest
implements ToCopyableBuilder<Builder, StartWorkflowRunRequest> {
    private static final SdkField<String> WORKFLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowArn").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::workflowArn)).setter(StartWorkflowRunRequest.setter(Builder::workflowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::clientToken)).setter(StartWorkflowRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, Document>> OVERRIDE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OverrideParameters").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::overrideParameters)).setter(StartWorkflowRunRequest.setter(Builder::overrideParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowVersion").getter(StartWorkflowRunRequest.getter(StartWorkflowRunRequest::workflowVersion)).setter(StartWorkflowRunRequest.setter(Builder::workflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ARN_FIELD, CLIENT_TOKEN_FIELD, OVERRIDE_PARAMETERS_FIELD, WORKFLOW_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartWorkflowRunRequest.memberNameToFieldInitializer();
    private final String workflowArn;
    private final String clientToken;
    private final Map<String, Document> overrideParameters;
    private final String workflowVersion;

    private StartWorkflowRunRequest(BuilderImpl builder) {
        super(builder);
        this.workflowArn = builder.workflowArn;
        this.clientToken = builder.clientToken;
        this.overrideParameters = builder.overrideParameters;
        this.workflowVersion = builder.workflowVersion;
    }

    public final String workflowArn() {
        return this.workflowArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasOverrideParameters() {
        return this.overrideParameters != null && !(this.overrideParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> overrideParameters() {
        return this.overrideParameters;
    }

    public final String workflowVersion() {
        return this.workflowVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrideParameters() ? this.overrideParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWorkflowRunRequest)) {
            return false;
        }
        StartWorkflowRunRequest other = (StartWorkflowRunRequest)((Object)obj);
        return Objects.equals(this.workflowArn(), other.workflowArn()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasOverrideParameters() == other.hasOverrideParameters() && Objects.equals(this.overrideParameters(), other.overrideParameters()) && Objects.equals(this.workflowVersion(), other.workflowVersion());
    }

    public final String toString() {
        return ToString.builder((String)"StartWorkflowRunRequest").add("WorkflowArn", (Object)this.workflowArn()).add("ClientToken", (Object)this.clientToken()).add("OverrideParameters", (Object)(this.overrideParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkflowVersion", (Object)this.workflowVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowArn": {
                return Optional.ofNullable(clazz.cast(this.workflowArn()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "OverrideParameters": {
                return Optional.ofNullable(clazz.cast(this.overrideParameters()));
            }
            case "WorkflowVersion": {
                return Optional.ofNullable(clazz.cast(this.workflowVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowArn", WORKFLOW_ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("OverrideParameters", OVERRIDE_PARAMETERS_FIELD);
        map.put("WorkflowVersion", WORKFLOW_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWorkflowRunRequest, T> g) {
        return obj -> g.apply((StartWorkflowRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaServerlessRequest.BuilderImpl
    implements Builder {
        private String workflowArn;
        private String clientToken;
        private Map<String, Document> overrideParameters = DefaultSdkAutoConstructMap.getInstance();
        private String workflowVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWorkflowRunRequest model) {
            super(model);
            this.workflowArn(model.workflowArn);
            this.clientToken(model.clientToken);
            this.overrideParameters(model.overrideParameters);
            this.workflowVersion(model.workflowVersion);
        }

        public final String getWorkflowArn() {
            return this.workflowArn;
        }

        public final void setWorkflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
        }

        @Override
        public final Builder workflowArn(String workflowArn) {
            this.workflowArn = workflowArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, Document> getOverrideParameters() {
            if (this.overrideParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.overrideParameters;
        }

        public final void setOverrideParameters(Map<String, Document> overrideParameters) {
            this.overrideParameters = ObjectMapCopier.copy(overrideParameters);
        }

        @Override
        public final Builder overrideParameters(Map<String, Document> overrideParameters) {
            this.overrideParameters = ObjectMapCopier.copy(overrideParameters);
            return this;
        }

        public final String getWorkflowVersion() {
            return this.workflowVersion;
        }

        public final void setWorkflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
        }

        @Override
        public final Builder workflowVersion(String workflowVersion) {
            this.workflowVersion = workflowVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartWorkflowRunRequest build() {
            return new StartWorkflowRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartWorkflowRunRequest> {
        public Builder workflowArn(String var1);

        public Builder clientToken(String var1);

        public Builder overrideParameters(Map<String, Document> var1);

        public Builder workflowVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

