/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaaserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaaserverless.model.WorkflowRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunDetailSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RunDetailSummary> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(RunDetailSummary.getter(RunDetailSummary::statusAsString)).setter(RunDetailSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedOn").getter(RunDetailSummary.getter(RunDetailSummary::createdOn)).setter(RunDetailSummary.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(RunDetailSummary.getter(RunDetailSummary::startedAt)).setter(RunDetailSummary.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndedAt").getter(RunDetailSummary.getter(RunDetailSummary::endedAt)).setter(RunDetailSummary.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CREATED_ON_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RunDetailSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant createdOn;
    private final Instant startedAt;
    private final Instant endedAt;

    private RunDetailSummary(BuilderImpl builder) {
        this.status = builder.status;
        this.createdOn = builder.createdOn;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
    }

    public final WorkflowRunStatus status() {
        return WorkflowRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdOn() {
        return this.createdOn;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunDetailSummary)) {
            return false;
        }
        RunDetailSummary other = (RunDetailSummary)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt());
    }

    public final String toString() {
        return ToString.builder((String)"RunDetailSummary").add("Status", (Object)this.statusAsString()).add("CreatedOn", (Object)this.createdOn()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "EndedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("CreatedOn", CREATED_ON_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunDetailSummary, T> g) {
        return obj -> g.apply((RunDetailSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant createdOn;
        private Instant startedAt;
        private Instant endedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(RunDetailSummary model) {
            this.status(model.status);
            this.createdOn(model.createdOn);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public RunDetailSummary build() {
            return new RunDetailSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RunDetailSummary> {
        public Builder status(String var1);

        public Builder status(WorkflowRunStatus var1);

        public Builder createdOn(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);
    }
}

