/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.MwaaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWebLoginTokenResponse
extends MwaaResponse
implements ToCopyableBuilder<Builder, CreateWebLoginTokenResponse> {
    private static final SdkField<String> WEB_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebToken").getter(CreateWebLoginTokenResponse.getter(CreateWebLoginTokenResponse::webToken)).setter(CreateWebLoginTokenResponse.setter(Builder::webToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebToken").build()}).build();
    private static final SdkField<String> WEB_SERVER_HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebServerHostname").getter(CreateWebLoginTokenResponse.getter(CreateWebLoginTokenResponse::webServerHostname)).setter(CreateWebLoginTokenResponse.setter(Builder::webServerHostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebServerHostname").build()}).build();
    private static final SdkField<String> IAM_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamIdentity").getter(CreateWebLoginTokenResponse.getter(CreateWebLoginTokenResponse::iamIdentity)).setter(CreateWebLoginTokenResponse.setter(Builder::iamIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamIdentity").build()}).build();
    private static final SdkField<String> AIRFLOW_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AirflowIdentity").getter(CreateWebLoginTokenResponse.getter(CreateWebLoginTokenResponse::airflowIdentity)).setter(CreateWebLoginTokenResponse.setter(Builder::airflowIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowIdentity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_TOKEN_FIELD, WEB_SERVER_HOSTNAME_FIELD, IAM_IDENTITY_FIELD, AIRFLOW_IDENTITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateWebLoginTokenResponse.memberNameToFieldInitializer();
    private final String webToken;
    private final String webServerHostname;
    private final String iamIdentity;
    private final String airflowIdentity;

    private CreateWebLoginTokenResponse(BuilderImpl builder) {
        super(builder);
        this.webToken = builder.webToken;
        this.webServerHostname = builder.webServerHostname;
        this.iamIdentity = builder.iamIdentity;
        this.airflowIdentity = builder.airflowIdentity;
    }

    public final String webToken() {
        return this.webToken;
    }

    public final String webServerHostname() {
        return this.webServerHostname;
    }

    public final String iamIdentity() {
        return this.iamIdentity;
    }

    public final String airflowIdentity() {
        return this.airflowIdentity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.webServerHostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.airflowIdentity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebLoginTokenResponse)) {
            return false;
        }
        CreateWebLoginTokenResponse other = (CreateWebLoginTokenResponse)((Object)obj);
        return Objects.equals(this.webToken(), other.webToken()) && Objects.equals(this.webServerHostname(), other.webServerHostname()) && Objects.equals(this.iamIdentity(), other.iamIdentity()) && Objects.equals(this.airflowIdentity(), other.airflowIdentity());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWebLoginTokenResponse").add("WebToken", (Object)(this.webToken() == null ? null : "*** Sensitive Data Redacted ***")).add("WebServerHostname", (Object)this.webServerHostname()).add("IamIdentity", (Object)this.iamIdentity()).add("AirflowIdentity", (Object)this.airflowIdentity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebToken": {
                return Optional.ofNullable(clazz.cast(this.webToken()));
            }
            case "WebServerHostname": {
                return Optional.ofNullable(clazz.cast(this.webServerHostname()));
            }
            case "IamIdentity": {
                return Optional.ofNullable(clazz.cast(this.iamIdentity()));
            }
            case "AirflowIdentity": {
                return Optional.ofNullable(clazz.cast(this.airflowIdentity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WebToken", WEB_TOKEN_FIELD);
        map.put("WebServerHostname", WEB_SERVER_HOSTNAME_FIELD);
        map.put("IamIdentity", IAM_IDENTITY_FIELD);
        map.put("AirflowIdentity", AIRFLOW_IDENTITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWebLoginTokenResponse, T> g) {
        return obj -> g.apply((CreateWebLoginTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MwaaResponse.BuilderImpl
    implements Builder {
        private String webToken;
        private String webServerHostname;
        private String iamIdentity;
        private String airflowIdentity;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebLoginTokenResponse model) {
            super(model);
            this.webToken(model.webToken);
            this.webServerHostname(model.webServerHostname);
            this.iamIdentity(model.iamIdentity);
            this.airflowIdentity(model.airflowIdentity);
        }

        public final String getWebToken() {
            return this.webToken;
        }

        public final void setWebToken(String webToken) {
            this.webToken = webToken;
        }

        @Override
        public final Builder webToken(String webToken) {
            this.webToken = webToken;
            return this;
        }

        public final String getWebServerHostname() {
            return this.webServerHostname;
        }

        public final void setWebServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
        }

        @Override
        public final Builder webServerHostname(String webServerHostname) {
            this.webServerHostname = webServerHostname;
            return this;
        }

        public final String getIamIdentity() {
            return this.iamIdentity;
        }

        public final void setIamIdentity(String iamIdentity) {
            this.iamIdentity = iamIdentity;
        }

        @Override
        public final Builder iamIdentity(String iamIdentity) {
            this.iamIdentity = iamIdentity;
            return this;
        }

        public final String getAirflowIdentity() {
            return this.airflowIdentity;
        }

        public final void setAirflowIdentity(String airflowIdentity) {
            this.airflowIdentity = airflowIdentity;
        }

        @Override
        public final Builder airflowIdentity(String airflowIdentity) {
            this.airflowIdentity = airflowIdentity;
            return this;
        }

        @Override
        public CreateWebLoginTokenResponse build() {
            return new CreateWebLoginTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MwaaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWebLoginTokenResponse> {
        public Builder webToken(String var1);

        public Builder webServerHostname(String var1);

        public Builder iamIdentity(String var1);

        public Builder airflowIdentity(String var1);
    }
}

