/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mwaa.model.AirflowConfigurationOptionsCopier;
import software.amazon.awssdk.services.mwaa.model.EndpointManagement;
import software.amazon.awssdk.services.mwaa.model.EnvironmentStatus;
import software.amazon.awssdk.services.mwaa.model.LastUpdate;
import software.amazon.awssdk.services.mwaa.model.LoggingConfiguration;
import software.amazon.awssdk.services.mwaa.model.NetworkConfiguration;
import software.amazon.awssdk.services.mwaa.model.TagMapCopier;
import software.amazon.awssdk.services.mwaa.model.WebserverAccessMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Environment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Environment> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Environment.getter(Environment::name)).setter(Environment.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Environment.getter(Environment::statusAsString)).setter(Environment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Environment.getter(Environment::arn)).setter(Environment.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Environment.getter(Environment::createdAt)).setter(Environment.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> WEBSERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebserverUrl").getter(Environment.getter(Environment::webserverUrl)).setter(Environment.setter(Builder::webserverUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverUrl").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(Environment.getter(Environment::executionRoleArn)).setter(Environment.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRoleArn").getter(Environment.getter(Environment::serviceRoleArn)).setter(Environment.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(Environment.getter(Environment::kmsKey)).setter(Environment.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final SdkField<String> AIRFLOW_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AirflowVersion").getter(Environment.getter(Environment::airflowVersion)).setter(Environment.setter(Builder::airflowVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowVersion").build()}).build();
    private static final SdkField<String> SOURCE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBucketArn").getter(Environment.getter(Environment::sourceBucketArn)).setter(Environment.setter(Builder::sourceBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucketArn").build()}).build();
    private static final SdkField<String> DAG_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DagS3Path").getter(Environment.getter(Environment::dagS3Path)).setter(Environment.setter(Builder::dagS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagS3Path").build()}).build();
    private static final SdkField<String> PLUGINS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginsS3Path").getter(Environment.getter(Environment::pluginsS3Path)).setter(Environment.setter(Builder::pluginsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3Path").build()}).build();
    private static final SdkField<String> PLUGINS_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginsS3ObjectVersion").getter(Environment.getter(Environment::pluginsS3ObjectVersion)).setter(Environment.setter(Builder::pluginsS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginsS3ObjectVersion").build()}).build();
    private static final SdkField<String> REQUIREMENTS_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequirementsS3Path").getter(Environment.getter(Environment::requirementsS3Path)).setter(Environment.setter(Builder::requirementsS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3Path").build()}).build();
    private static final SdkField<String> REQUIREMENTS_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequirementsS3ObjectVersion").getter(Environment.getter(Environment::requirementsS3ObjectVersion)).setter(Environment.setter(Builder::requirementsS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequirementsS3ObjectVersion").build()}).build();
    private static final SdkField<String> STARTUP_SCRIPT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartupScriptS3Path").getter(Environment.getter(Environment::startupScriptS3Path)).setter(Environment.setter(Builder::startupScriptS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3Path").build()}).build();
    private static final SdkField<String> STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartupScriptS3ObjectVersion").getter(Environment.getter(Environment::startupScriptS3ObjectVersion)).setter(Environment.setter(Builder::startupScriptS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupScriptS3ObjectVersion").build()}).build();
    private static final SdkField<Map<String, String>> AIRFLOW_CONFIGURATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AirflowConfigurationOptions").getter(Environment.getter(Environment::airflowConfigurationOptions)).setter(Environment.setter(Builder::airflowConfigurationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AirflowConfigurationOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ENVIRONMENT_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentClass").getter(Environment.getter(Environment::environmentClass)).setter(Environment.setter(Builder::environmentClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentClass").build()}).build();
    private static final SdkField<Integer> MAX_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxWorkers").getter(Environment.getter(Environment::maxWorkers)).setter(Environment.setter(Builder::maxWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWorkers").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(Environment.getter(Environment::networkConfiguration)).setter(Environment.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<LoggingConfiguration> LOGGING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfiguration").getter(Environment.getter(Environment::loggingConfiguration)).setter(Environment.setter(Builder::loggingConfiguration)).constructor(LoggingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfiguration").build()}).build();
    private static final SdkField<LastUpdate> LAST_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastUpdate").getter(Environment.getter(Environment::lastUpdate)).setter(Environment.setter(Builder::lastUpdate)).constructor(LastUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdate").build()}).build();
    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WeeklyMaintenanceWindowStart").getter(Environment.getter(Environment::weeklyMaintenanceWindowStart)).setter(Environment.setter(Builder::weeklyMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Environment.getter(Environment::tags)).setter(Environment.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> WEBSERVER_ACCESS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebserverAccessMode").getter(Environment.getter(Environment::webserverAccessModeAsString)).setter(Environment.setter(Builder::webserverAccessMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverAccessMode").build()}).build();
    private static final SdkField<Integer> MIN_WORKERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinWorkers").getter(Environment.getter(Environment::minWorkers)).setter(Environment.setter(Builder::minWorkers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWorkers").build()}).build();
    private static final SdkField<Integer> SCHEDULERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Schedulers").getter(Environment.getter(Environment::schedulers)).setter(Environment.setter(Builder::schedulers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedulers").build()}).build();
    private static final SdkField<String> WEBSERVER_VPC_ENDPOINT_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebserverVpcEndpointService").getter(Environment.getter(Environment::webserverVpcEndpointService)).setter(Environment.setter(Builder::webserverVpcEndpointService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverVpcEndpointService").build()}).build();
    private static final SdkField<String> DATABASE_VPC_ENDPOINT_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseVpcEndpointService").getter(Environment.getter(Environment::databaseVpcEndpointService)).setter(Environment.setter(Builder::databaseVpcEndpointService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseVpcEndpointService").build()}).build();
    private static final SdkField<String> CELERY_EXECUTOR_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CeleryExecutorQueue").getter(Environment.getter(Environment::celeryExecutorQueue)).setter(Environment.setter(Builder::celeryExecutorQueue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CeleryExecutorQueue").build()}).build();
    private static final SdkField<String> ENDPOINT_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointManagement").getter(Environment.getter(Environment::endpointManagementAsString)).setter(Environment.setter(Builder::endpointManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointManagement").build()}).build();
    private static final SdkField<Integer> MIN_WEBSERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinWebservers").getter(Environment.getter(Environment::minWebservers)).setter(Environment.setter(Builder::minWebservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinWebservers").build()}).build();
    private static final SdkField<Integer> MAX_WEBSERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxWebservers").getter(Environment.getter(Environment::maxWebservers)).setter(Environment.setter(Builder::maxWebservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWebservers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, ARN_FIELD, CREATED_AT_FIELD, WEBSERVER_URL_FIELD, EXECUTION_ROLE_ARN_FIELD, SERVICE_ROLE_ARN_FIELD, KMS_KEY_FIELD, AIRFLOW_VERSION_FIELD, SOURCE_BUCKET_ARN_FIELD, DAG_S3_PATH_FIELD, PLUGINS_S3_PATH_FIELD, PLUGINS_S3_OBJECT_VERSION_FIELD, REQUIREMENTS_S3_PATH_FIELD, REQUIREMENTS_S3_OBJECT_VERSION_FIELD, STARTUP_SCRIPT_S3_PATH_FIELD, STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD, AIRFLOW_CONFIGURATION_OPTIONS_FIELD, ENVIRONMENT_CLASS_FIELD, MAX_WORKERS_FIELD, NETWORK_CONFIGURATION_FIELD, LOGGING_CONFIGURATION_FIELD, LAST_UPDATE_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, TAGS_FIELD, WEBSERVER_ACCESS_MODE_FIELD, MIN_WORKERS_FIELD, SCHEDULERS_FIELD, WEBSERVER_VPC_ENDPOINT_SERVICE_FIELD, DATABASE_VPC_ENDPOINT_SERVICE_FIELD, CELERY_EXECUTOR_QUEUE_FIELD, ENDPOINT_MANAGEMENT_FIELD, MIN_WEBSERVERS_FIELD, MAX_WEBSERVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("WebserverUrl", WEBSERVER_URL_FIELD);
            this.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("ServiceRoleArn", SERVICE_ROLE_ARN_FIELD);
            this.put("KmsKey", KMS_KEY_FIELD);
            this.put("AirflowVersion", AIRFLOW_VERSION_FIELD);
            this.put("SourceBucketArn", SOURCE_BUCKET_ARN_FIELD);
            this.put("DagS3Path", DAG_S3_PATH_FIELD);
            this.put("PluginsS3Path", PLUGINS_S3_PATH_FIELD);
            this.put("PluginsS3ObjectVersion", PLUGINS_S3_OBJECT_VERSION_FIELD);
            this.put("RequirementsS3Path", REQUIREMENTS_S3_PATH_FIELD);
            this.put("RequirementsS3ObjectVersion", REQUIREMENTS_S3_OBJECT_VERSION_FIELD);
            this.put("StartupScriptS3Path", STARTUP_SCRIPT_S3_PATH_FIELD);
            this.put("StartupScriptS3ObjectVersion", STARTUP_SCRIPT_S3_OBJECT_VERSION_FIELD);
            this.put("AirflowConfigurationOptions", AIRFLOW_CONFIGURATION_OPTIONS_FIELD);
            this.put("EnvironmentClass", ENVIRONMENT_CLASS_FIELD);
            this.put("MaxWorkers", MAX_WORKERS_FIELD);
            this.put("NetworkConfiguration", NETWORK_CONFIGURATION_FIELD);
            this.put("LoggingConfiguration", LOGGING_CONFIGURATION_FIELD);
            this.put("LastUpdate", LAST_UPDATE_FIELD);
            this.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("WebserverAccessMode", WEBSERVER_ACCESS_MODE_FIELD);
            this.put("MinWorkers", MIN_WORKERS_FIELD);
            this.put("Schedulers", SCHEDULERS_FIELD);
            this.put("WebserverVpcEndpointService", WEBSERVER_VPC_ENDPOINT_SERVICE_FIELD);
            this.put("DatabaseVpcEndpointService", DATABASE_VPC_ENDPOINT_SERVICE_FIELD);
            this.put("CeleryExecutorQueue", CELERY_EXECUTOR_QUEUE_FIELD);
            this.put("EndpointManagement", ENDPOINT_MANAGEMENT_FIELD);
            this.put("MinWebservers", MIN_WEBSERVERS_FIELD);
            this.put("MaxWebservers", MAX_WEBSERVERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final String arn;
    private final Instant createdAt;
    private final String webserverUrl;
    private final String executionRoleArn;
    private final String serviceRoleArn;
    private final String kmsKey;
    private final String airflowVersion;
    private final String sourceBucketArn;
    private final String dagS3Path;
    private final String pluginsS3Path;
    private final String pluginsS3ObjectVersion;
    private final String requirementsS3Path;
    private final String requirementsS3ObjectVersion;
    private final String startupScriptS3Path;
    private final String startupScriptS3ObjectVersion;
    private final Map<String, String> airflowConfigurationOptions;
    private final String environmentClass;
    private final Integer maxWorkers;
    private final NetworkConfiguration networkConfiguration;
    private final LoggingConfiguration loggingConfiguration;
    private final LastUpdate lastUpdate;
    private final String weeklyMaintenanceWindowStart;
    private final Map<String, String> tags;
    private final String webserverAccessMode;
    private final Integer minWorkers;
    private final Integer schedulers;
    private final String webserverVpcEndpointService;
    private final String databaseVpcEndpointService;
    private final String celeryExecutorQueue;
    private final String endpointManagement;
    private final Integer minWebservers;
    private final Integer maxWebservers;

    private Environment(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.webserverUrl = builder.webserverUrl;
        this.executionRoleArn = builder.executionRoleArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.kmsKey = builder.kmsKey;
        this.airflowVersion = builder.airflowVersion;
        this.sourceBucketArn = builder.sourceBucketArn;
        this.dagS3Path = builder.dagS3Path;
        this.pluginsS3Path = builder.pluginsS3Path;
        this.pluginsS3ObjectVersion = builder.pluginsS3ObjectVersion;
        this.requirementsS3Path = builder.requirementsS3Path;
        this.requirementsS3ObjectVersion = builder.requirementsS3ObjectVersion;
        this.startupScriptS3Path = builder.startupScriptS3Path;
        this.startupScriptS3ObjectVersion = builder.startupScriptS3ObjectVersion;
        this.airflowConfigurationOptions = builder.airflowConfigurationOptions;
        this.environmentClass = builder.environmentClass;
        this.maxWorkers = builder.maxWorkers;
        this.networkConfiguration = builder.networkConfiguration;
        this.loggingConfiguration = builder.loggingConfiguration;
        this.lastUpdate = builder.lastUpdate;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.tags = builder.tags;
        this.webserverAccessMode = builder.webserverAccessMode;
        this.minWorkers = builder.minWorkers;
        this.schedulers = builder.schedulers;
        this.webserverVpcEndpointService = builder.webserverVpcEndpointService;
        this.databaseVpcEndpointService = builder.databaseVpcEndpointService;
        this.celeryExecutorQueue = builder.celeryExecutorQueue;
        this.endpointManagement = builder.endpointManagement;
        this.minWebservers = builder.minWebservers;
        this.maxWebservers = builder.maxWebservers;
    }

    public final String name() {
        return this.name;
    }

    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String webserverUrl() {
        return this.webserverUrl;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public final String airflowVersion() {
        return this.airflowVersion;
    }

    public final String sourceBucketArn() {
        return this.sourceBucketArn;
    }

    public final String dagS3Path() {
        return this.dagS3Path;
    }

    public final String pluginsS3Path() {
        return this.pluginsS3Path;
    }

    public final String pluginsS3ObjectVersion() {
        return this.pluginsS3ObjectVersion;
    }

    public final String requirementsS3Path() {
        return this.requirementsS3Path;
    }

    public final String requirementsS3ObjectVersion() {
        return this.requirementsS3ObjectVersion;
    }

    public final String startupScriptS3Path() {
        return this.startupScriptS3Path;
    }

    public final String startupScriptS3ObjectVersion() {
        return this.startupScriptS3ObjectVersion;
    }

    public final boolean hasAirflowConfigurationOptions() {
        return this.airflowConfigurationOptions != null && !(this.airflowConfigurationOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> airflowConfigurationOptions() {
        return this.airflowConfigurationOptions;
    }

    public final String environmentClass() {
        return this.environmentClass;
    }

    public final Integer maxWorkers() {
        return this.maxWorkers;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final LoggingConfiguration loggingConfiguration() {
        return this.loggingConfiguration;
    }

    public final LastUpdate lastUpdate() {
        return this.lastUpdate;
    }

    public final String weeklyMaintenanceWindowStart() {
        return this.weeklyMaintenanceWindowStart;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final WebserverAccessMode webserverAccessMode() {
        return WebserverAccessMode.fromValue(this.webserverAccessMode);
    }

    public final String webserverAccessModeAsString() {
        return this.webserverAccessMode;
    }

    public final Integer minWorkers() {
        return this.minWorkers;
    }

    public final Integer schedulers() {
        return this.schedulers;
    }

    public final String webserverVpcEndpointService() {
        return this.webserverVpcEndpointService;
    }

    public final String databaseVpcEndpointService() {
        return this.databaseVpcEndpointService;
    }

    public final String celeryExecutorQueue() {
        return this.celeryExecutorQueue;
    }

    public final EndpointManagement endpointManagement() {
        return EndpointManagement.fromValue(this.endpointManagement);
    }

    public final String endpointManagementAsString() {
        return this.endpointManagement;
    }

    public final Integer minWebservers() {
        return this.minWebservers;
    }

    public final Integer maxWebservers() {
        return this.maxWebservers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.airflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dagS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementsS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.requirementsS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.startupScriptS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.startupScriptS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAirflowConfigurationOptions() ? this.airflowConfigurationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverAccessModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWorkers());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulers());
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverVpcEndpointService());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseVpcEndpointService());
        hashCode = 31 * hashCode + Objects.hashCode(this.celeryExecutorQueue());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minWebservers());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWebservers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.webserverUrl(), other.webserverUrl()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.airflowVersion(), other.airflowVersion()) && Objects.equals(this.sourceBucketArn(), other.sourceBucketArn()) && Objects.equals(this.dagS3Path(), other.dagS3Path()) && Objects.equals(this.pluginsS3Path(), other.pluginsS3Path()) && Objects.equals(this.pluginsS3ObjectVersion(), other.pluginsS3ObjectVersion()) && Objects.equals(this.requirementsS3Path(), other.requirementsS3Path()) && Objects.equals(this.requirementsS3ObjectVersion(), other.requirementsS3ObjectVersion()) && Objects.equals(this.startupScriptS3Path(), other.startupScriptS3Path()) && Objects.equals(this.startupScriptS3ObjectVersion(), other.startupScriptS3ObjectVersion()) && this.hasAirflowConfigurationOptions() == other.hasAirflowConfigurationOptions() && Objects.equals(this.airflowConfigurationOptions(), other.airflowConfigurationOptions()) && Objects.equals(this.environmentClass(), other.environmentClass()) && Objects.equals(this.maxWorkers(), other.maxWorkers()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.loggingConfiguration(), other.loggingConfiguration()) && Objects.equals(this.lastUpdate(), other.lastUpdate()) && Objects.equals(this.weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.webserverAccessModeAsString(), other.webserverAccessModeAsString()) && Objects.equals(this.minWorkers(), other.minWorkers()) && Objects.equals(this.schedulers(), other.schedulers()) && Objects.equals(this.webserverVpcEndpointService(), other.webserverVpcEndpointService()) && Objects.equals(this.databaseVpcEndpointService(), other.databaseVpcEndpointService()) && Objects.equals(this.celeryExecutorQueue(), other.celeryExecutorQueue()) && Objects.equals(this.endpointManagementAsString(), other.endpointManagementAsString()) && Objects.equals(this.minWebservers(), other.minWebservers()) && Objects.equals(this.maxWebservers(), other.maxWebservers());
    }

    public final String toString() {
        return ToString.builder((String)"Environment").add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("WebserverUrl", (Object)this.webserverUrl()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("KmsKey", (Object)this.kmsKey()).add("AirflowVersion", (Object)this.airflowVersion()).add("SourceBucketArn", (Object)this.sourceBucketArn()).add("DagS3Path", (Object)this.dagS3Path()).add("PluginsS3Path", (Object)this.pluginsS3Path()).add("PluginsS3ObjectVersion", (Object)this.pluginsS3ObjectVersion()).add("RequirementsS3Path", (Object)this.requirementsS3Path()).add("RequirementsS3ObjectVersion", (Object)this.requirementsS3ObjectVersion()).add("StartupScriptS3Path", (Object)this.startupScriptS3Path()).add("StartupScriptS3ObjectVersion", (Object)this.startupScriptS3ObjectVersion()).add("AirflowConfigurationOptions", (Object)(this.airflowConfigurationOptions() == null ? null : "*** Sensitive Data Redacted ***")).add("EnvironmentClass", (Object)this.environmentClass()).add("MaxWorkers", (Object)this.maxWorkers()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("LoggingConfiguration", (Object)this.loggingConfiguration()).add("LastUpdate", (Object)this.lastUpdate()).add("WeeklyMaintenanceWindowStart", (Object)this.weeklyMaintenanceWindowStart()).add("Tags", this.hasTags() ? this.tags() : null).add("WebserverAccessMode", (Object)this.webserverAccessModeAsString()).add("MinWorkers", (Object)this.minWorkers()).add("Schedulers", (Object)this.schedulers()).add("WebserverVpcEndpointService", (Object)this.webserverVpcEndpointService()).add("DatabaseVpcEndpointService", (Object)this.databaseVpcEndpointService()).add("CeleryExecutorQueue", (Object)this.celeryExecutorQueue()).add("EndpointManagement", (Object)this.endpointManagementAsString()).add("MinWebservers", (Object)this.minWebservers()).add("MaxWebservers", (Object)this.maxWebservers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "WebserverUrl": {
                return Optional.ofNullable(clazz.cast(this.webserverUrl()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "AirflowVersion": {
                return Optional.ofNullable(clazz.cast(this.airflowVersion()));
            }
            case "SourceBucketArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBucketArn()));
            }
            case "DagS3Path": {
                return Optional.ofNullable(clazz.cast(this.dagS3Path()));
            }
            case "PluginsS3Path": {
                return Optional.ofNullable(clazz.cast(this.pluginsS3Path()));
            }
            case "PluginsS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.pluginsS3ObjectVersion()));
            }
            case "RequirementsS3Path": {
                return Optional.ofNullable(clazz.cast(this.requirementsS3Path()));
            }
            case "RequirementsS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.requirementsS3ObjectVersion()));
            }
            case "StartupScriptS3Path": {
                return Optional.ofNullable(clazz.cast(this.startupScriptS3Path()));
            }
            case "StartupScriptS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.startupScriptS3ObjectVersion()));
            }
            case "AirflowConfigurationOptions": {
                return Optional.ofNullable(clazz.cast(this.airflowConfigurationOptions()));
            }
            case "EnvironmentClass": {
                return Optional.ofNullable(clazz.cast(this.environmentClass()));
            }
            case "MaxWorkers": {
                return Optional.ofNullable(clazz.cast(this.maxWorkers()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "LoggingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.loggingConfiguration()));
            }
            case "LastUpdate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdate()));
            }
            case "WeeklyMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.weeklyMaintenanceWindowStart()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "WebserverAccessMode": {
                return Optional.ofNullable(clazz.cast(this.webserverAccessModeAsString()));
            }
            case "MinWorkers": {
                return Optional.ofNullable(clazz.cast(this.minWorkers()));
            }
            case "Schedulers": {
                return Optional.ofNullable(clazz.cast(this.schedulers()));
            }
            case "WebserverVpcEndpointService": {
                return Optional.ofNullable(clazz.cast(this.webserverVpcEndpointService()));
            }
            case "DatabaseVpcEndpointService": {
                return Optional.ofNullable(clazz.cast(this.databaseVpcEndpointService()));
            }
            case "CeleryExecutorQueue": {
                return Optional.ofNullable(clazz.cast(this.celeryExecutorQueue()));
            }
            case "EndpointManagement": {
                return Optional.ofNullable(clazz.cast(this.endpointManagementAsString()));
            }
            case "MinWebservers": {
                return Optional.ofNullable(clazz.cast(this.minWebservers()));
            }
            case "MaxWebservers": {
                return Optional.ofNullable(clazz.cast(this.maxWebservers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String arn;
        private Instant createdAt;
        private String webserverUrl;
        private String executionRoleArn;
        private String serviceRoleArn;
        private String kmsKey;
        private String airflowVersion;
        private String sourceBucketArn;
        private String dagS3Path;
        private String pluginsS3Path;
        private String pluginsS3ObjectVersion;
        private String requirementsS3Path;
        private String requirementsS3ObjectVersion;
        private String startupScriptS3Path;
        private String startupScriptS3ObjectVersion;
        private Map<String, String> airflowConfigurationOptions = DefaultSdkAutoConstructMap.getInstance();
        private String environmentClass;
        private Integer maxWorkers;
        private NetworkConfiguration networkConfiguration;
        private LoggingConfiguration loggingConfiguration;
        private LastUpdate lastUpdate;
        private String weeklyMaintenanceWindowStart;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String webserverAccessMode;
        private Integer minWorkers;
        private Integer schedulers;
        private String webserverVpcEndpointService;
        private String databaseVpcEndpointService;
        private String celeryExecutorQueue;
        private String endpointManagement;
        private Integer minWebservers;
        private Integer maxWebservers;

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            this.name(model.name);
            this.status(model.status);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.webserverUrl(model.webserverUrl);
            this.executionRoleArn(model.executionRoleArn);
            this.serviceRoleArn(model.serviceRoleArn);
            this.kmsKey(model.kmsKey);
            this.airflowVersion(model.airflowVersion);
            this.sourceBucketArn(model.sourceBucketArn);
            this.dagS3Path(model.dagS3Path);
            this.pluginsS3Path(model.pluginsS3Path);
            this.pluginsS3ObjectVersion(model.pluginsS3ObjectVersion);
            this.requirementsS3Path(model.requirementsS3Path);
            this.requirementsS3ObjectVersion(model.requirementsS3ObjectVersion);
            this.startupScriptS3Path(model.startupScriptS3Path);
            this.startupScriptS3ObjectVersion(model.startupScriptS3ObjectVersion);
            this.airflowConfigurationOptions(model.airflowConfigurationOptions);
            this.environmentClass(model.environmentClass);
            this.maxWorkers(model.maxWorkers);
            this.networkConfiguration(model.networkConfiguration);
            this.loggingConfiguration(model.loggingConfiguration);
            this.lastUpdate(model.lastUpdate);
            this.weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            this.tags(model.tags);
            this.webserverAccessMode(model.webserverAccessMode);
            this.minWorkers(model.minWorkers);
            this.schedulers(model.schedulers);
            this.webserverVpcEndpointService(model.webserverVpcEndpointService);
            this.databaseVpcEndpointService(model.databaseVpcEndpointService);
            this.celeryExecutorQueue(model.celeryExecutorQueue);
            this.endpointManagement(model.endpointManagement);
            this.minWebservers(model.minWebservers);
            this.maxWebservers(model.maxWebservers);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getWebserverUrl() {
            return this.webserverUrl;
        }

        public final void setWebserverUrl(String webserverUrl) {
            this.webserverUrl = webserverUrl;
        }

        @Override
        public final Builder webserverUrl(String webserverUrl) {
            this.webserverUrl = webserverUrl;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final String getAirflowVersion() {
            return this.airflowVersion;
        }

        public final void setAirflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
        }

        @Override
        public final Builder airflowVersion(String airflowVersion) {
            this.airflowVersion = airflowVersion;
            return this;
        }

        public final String getSourceBucketArn() {
            return this.sourceBucketArn;
        }

        public final void setSourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
        }

        @Override
        public final Builder sourceBucketArn(String sourceBucketArn) {
            this.sourceBucketArn = sourceBucketArn;
            return this;
        }

        public final String getDagS3Path() {
            return this.dagS3Path;
        }

        public final void setDagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
        }

        @Override
        public final Builder dagS3Path(String dagS3Path) {
            this.dagS3Path = dagS3Path;
            return this;
        }

        public final String getPluginsS3Path() {
            return this.pluginsS3Path;
        }

        public final void setPluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
        }

        @Override
        public final Builder pluginsS3Path(String pluginsS3Path) {
            this.pluginsS3Path = pluginsS3Path;
            return this;
        }

        public final String getPluginsS3ObjectVersion() {
            return this.pluginsS3ObjectVersion;
        }

        public final void setPluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
        }

        @Override
        public final Builder pluginsS3ObjectVersion(String pluginsS3ObjectVersion) {
            this.pluginsS3ObjectVersion = pluginsS3ObjectVersion;
            return this;
        }

        public final String getRequirementsS3Path() {
            return this.requirementsS3Path;
        }

        public final void setRequirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
        }

        @Override
        public final Builder requirementsS3Path(String requirementsS3Path) {
            this.requirementsS3Path = requirementsS3Path;
            return this;
        }

        public final String getRequirementsS3ObjectVersion() {
            return this.requirementsS3ObjectVersion;
        }

        public final void setRequirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
        }

        @Override
        public final Builder requirementsS3ObjectVersion(String requirementsS3ObjectVersion) {
            this.requirementsS3ObjectVersion = requirementsS3ObjectVersion;
            return this;
        }

        public final String getStartupScriptS3Path() {
            return this.startupScriptS3Path;
        }

        public final void setStartupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
        }

        @Override
        public final Builder startupScriptS3Path(String startupScriptS3Path) {
            this.startupScriptS3Path = startupScriptS3Path;
            return this;
        }

        public final String getStartupScriptS3ObjectVersion() {
            return this.startupScriptS3ObjectVersion;
        }

        public final void setStartupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
        }

        @Override
        public final Builder startupScriptS3ObjectVersion(String startupScriptS3ObjectVersion) {
            this.startupScriptS3ObjectVersion = startupScriptS3ObjectVersion;
            return this;
        }

        public final Map<String, String> getAirflowConfigurationOptions() {
            if (this.airflowConfigurationOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.airflowConfigurationOptions;
        }

        public final void setAirflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
        }

        @Override
        public final Builder airflowConfigurationOptions(Map<String, String> airflowConfigurationOptions) {
            this.airflowConfigurationOptions = AirflowConfigurationOptionsCopier.copy(airflowConfigurationOptions);
            return this;
        }

        public final String getEnvironmentClass() {
            return this.environmentClass;
        }

        public final void setEnvironmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
        }

        @Override
        public final Builder environmentClass(String environmentClass) {
            this.environmentClass = environmentClass;
            return this;
        }

        public final Integer getMaxWorkers() {
            return this.maxWorkers;
        }

        public final void setMaxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
        }

        @Override
        public final Builder maxWorkers(Integer maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final LoggingConfiguration.Builder getLoggingConfiguration() {
            return this.loggingConfiguration != null ? this.loggingConfiguration.toBuilder() : null;
        }

        public final void setLoggingConfiguration(LoggingConfiguration.BuilderImpl loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration != null ? loggingConfiguration.build() : null;
        }

        @Override
        public final Builder loggingConfiguration(LoggingConfiguration loggingConfiguration) {
            this.loggingConfiguration = loggingConfiguration;
            return this;
        }

        public final LastUpdate.Builder getLastUpdate() {
            return this.lastUpdate != null ? this.lastUpdate.toBuilder() : null;
        }

        public final void setLastUpdate(LastUpdate.BuilderImpl lastUpdate) {
            this.lastUpdate = lastUpdate != null ? lastUpdate.build() : null;
        }

        @Override
        public final Builder lastUpdate(LastUpdate lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return this.weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWebserverAccessMode() {
            return this.webserverAccessMode;
        }

        public final void setWebserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
        }

        @Override
        public final Builder webserverAccessMode(String webserverAccessMode) {
            this.webserverAccessMode = webserverAccessMode;
            return this;
        }

        @Override
        public final Builder webserverAccessMode(WebserverAccessMode webserverAccessMode) {
            this.webserverAccessMode(webserverAccessMode == null ? null : webserverAccessMode.toString());
            return this;
        }

        public final Integer getMinWorkers() {
            return this.minWorkers;
        }

        public final void setMinWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
        }

        @Override
        public final Builder minWorkers(Integer minWorkers) {
            this.minWorkers = minWorkers;
            return this;
        }

        public final Integer getSchedulers() {
            return this.schedulers;
        }

        public final void setSchedulers(Integer schedulers) {
            this.schedulers = schedulers;
        }

        @Override
        public final Builder schedulers(Integer schedulers) {
            this.schedulers = schedulers;
            return this;
        }

        public final String getWebserverVpcEndpointService() {
            return this.webserverVpcEndpointService;
        }

        public final void setWebserverVpcEndpointService(String webserverVpcEndpointService) {
            this.webserverVpcEndpointService = webserverVpcEndpointService;
        }

        @Override
        public final Builder webserverVpcEndpointService(String webserverVpcEndpointService) {
            this.webserverVpcEndpointService = webserverVpcEndpointService;
            return this;
        }

        public final String getDatabaseVpcEndpointService() {
            return this.databaseVpcEndpointService;
        }

        public final void setDatabaseVpcEndpointService(String databaseVpcEndpointService) {
            this.databaseVpcEndpointService = databaseVpcEndpointService;
        }

        @Override
        public final Builder databaseVpcEndpointService(String databaseVpcEndpointService) {
            this.databaseVpcEndpointService = databaseVpcEndpointService;
            return this;
        }

        public final String getCeleryExecutorQueue() {
            return this.celeryExecutorQueue;
        }

        public final void setCeleryExecutorQueue(String celeryExecutorQueue) {
            this.celeryExecutorQueue = celeryExecutorQueue;
        }

        @Override
        public final Builder celeryExecutorQueue(String celeryExecutorQueue) {
            this.celeryExecutorQueue = celeryExecutorQueue;
            return this;
        }

        public final String getEndpointManagement() {
            return this.endpointManagement;
        }

        public final void setEndpointManagement(String endpointManagement) {
            this.endpointManagement = endpointManagement;
        }

        @Override
        public final Builder endpointManagement(String endpointManagement) {
            this.endpointManagement = endpointManagement;
            return this;
        }

        @Override
        public final Builder endpointManagement(EndpointManagement endpointManagement) {
            this.endpointManagement(endpointManagement == null ? null : endpointManagement.toString());
            return this;
        }

        public final Integer getMinWebservers() {
            return this.minWebservers;
        }

        public final void setMinWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
        }

        @Override
        public final Builder minWebservers(Integer minWebservers) {
            this.minWebservers = minWebservers;
            return this;
        }

        public final Integer getMaxWebservers() {
            return this.maxWebservers;
        }

        public final void setMaxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
        }

        @Override
        public final Builder maxWebservers(Integer maxWebservers) {
            this.maxWebservers = maxWebservers;
            return this;
        }

        public Environment build() {
            return new Environment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Environment> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(EnvironmentStatus var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder webserverUrl(String var1);

        public Builder executionRoleArn(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder kmsKey(String var1);

        public Builder airflowVersion(String var1);

        public Builder sourceBucketArn(String var1);

        public Builder dagS3Path(String var1);

        public Builder pluginsS3Path(String var1);

        public Builder pluginsS3ObjectVersion(String var1);

        public Builder requirementsS3Path(String var1);

        public Builder requirementsS3ObjectVersion(String var1);

        public Builder startupScriptS3Path(String var1);

        public Builder startupScriptS3ObjectVersion(String var1);

        public Builder airflowConfigurationOptions(Map<String, String> var1);

        public Builder environmentClass(String var1);

        public Builder maxWorkers(Integer var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder loggingConfiguration(LoggingConfiguration var1);

        default public Builder loggingConfiguration(Consumer<LoggingConfiguration.Builder> loggingConfiguration) {
            return this.loggingConfiguration((LoggingConfiguration)((LoggingConfiguration.Builder)LoggingConfiguration.builder().applyMutation(loggingConfiguration)).build());
        }

        public Builder lastUpdate(LastUpdate var1);

        default public Builder lastUpdate(Consumer<LastUpdate.Builder> lastUpdate) {
            return this.lastUpdate((LastUpdate)((LastUpdate.Builder)LastUpdate.builder().applyMutation(lastUpdate)).build());
        }

        public Builder weeklyMaintenanceWindowStart(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder webserverAccessMode(String var1);

        public Builder webserverAccessMode(WebserverAccessMode var1);

        public Builder minWorkers(Integer var1);

        public Builder schedulers(Integer var1);

        public Builder webserverVpcEndpointService(String var1);

        public Builder databaseVpcEndpointService(String var1);

        public Builder celeryExecutorQueue(String var1);

        public Builder endpointManagement(String var1);

        public Builder endpointManagement(EndpointManagement var1);

        public Builder minWebservers(Integer var1);

        public Builder maxWebservers(Integer var1);
    }
}

