/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.Assignment;
import software.amazon.awssdk.services.mturk.model.AssignmentListCopier;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssignmentsForHitResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListAssignmentsForHitResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAssignmentsForHitResponse.getter(ListAssignmentsForHitResponse::nextToken)).setter(ListAssignmentsForHitResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumResults").getter(ListAssignmentsForHitResponse.getter(ListAssignmentsForHitResponse::numResults)).setter(ListAssignmentsForHitResponse.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()}).build();
    private static final SdkField<List<Assignment>> ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Assignments").getter(ListAssignmentsForHitResponse.getter(ListAssignmentsForHitResponse::assignments)).setter(ListAssignmentsForHitResponse.setter(Builder::assignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Assignment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NUM_RESULTS_FIELD, ASSIGNMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("NumResults", NUM_RESULTS_FIELD);
            this.put("Assignments", ASSIGNMENTS_FIELD);
        }
    });
    private final String nextToken;
    private final Integer numResults;
    private final List<Assignment> assignments;

    private ListAssignmentsForHitResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.numResults = builder.numResults;
        this.assignments = builder.assignments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final boolean hasAssignments() {
        return this.assignments != null && !(this.assignments instanceof SdkAutoConstructList);
    }

    public final List<Assignment> assignments() {
        return this.assignments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssignments() ? this.assignments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssignmentsForHitResponse)) {
            return false;
        }
        ListAssignmentsForHitResponse other = (ListAssignmentsForHitResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.numResults(), other.numResults()) && this.hasAssignments() == other.hasAssignments() && Objects.equals(this.assignments(), other.assignments());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssignmentsForHitResponse").add("NextToken", (Object)this.nextToken()).add("NumResults", (Object)this.numResults()).add("Assignments", this.hasAssignments() ? this.assignments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "Assignments": {
                return Optional.ofNullable(clazz.cast(this.assignments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAssignmentsForHitResponse, T> g) {
        return obj -> g.apply((ListAssignmentsForHitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer numResults;
        private List<Assignment> assignments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssignmentsForHitResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.numResults(model.numResults);
            this.assignments(model.assignments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final List<Assignment.Builder> getAssignments() {
            List<Assignment.Builder> result = AssignmentListCopier.copyToBuilder(this.assignments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssignments(Collection<Assignment.BuilderImpl> assignments) {
            this.assignments = AssignmentListCopier.copyFromBuilder(assignments);
        }

        @Override
        public final Builder assignments(Collection<Assignment> assignments) {
            this.assignments = AssignmentListCopier.copy(assignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignments(Assignment ... assignments) {
            this.assignments(Arrays.asList(assignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assignments(Consumer<Assignment.Builder> ... assignments) {
            this.assignments(Stream.of(assignments).map(c -> (Assignment)((Assignment.Builder)Assignment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAssignmentsForHitResponse build() {
            return new ListAssignmentsForHitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssignmentsForHitResponse> {
        public Builder nextToken(String var1);

        public Builder numResults(Integer var1);

        public Builder assignments(Collection<Assignment> var1);

        public Builder assignments(Assignment ... var1);

        public Builder assignments(Consumer<Assignment.Builder> ... var1);
    }
}

