/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HITReviewStatus {
    NOT_REVIEWED("NotReviewed"),
    MARKED_FOR_REVIEW("MarkedForReview"),
    REVIEWED_APPROPRIATE("ReviewedAppropriate"),
    REVIEWED_INAPPROPRIATE("ReviewedInappropriate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HITReviewStatus> VALUE_MAP;
    private final String value;

    private HITReviewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HITReviewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HITReviewStatus> knownValues() {
        EnumSet<HITReviewStatus> knownValues = EnumSet.allOf(HITReviewStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HITReviewStatus.class, HITReviewStatus::toString);
    }
}

