/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mturk.MTurkAsyncClient;
import software.amazon.awssdk.services.mturk.internal.UserAgentUtils;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse;

public class ListBonusPaymentsPublisher
implements SdkPublisher<ListBonusPaymentsResponse> {
    private final MTurkAsyncClient client;
    private final ListBonusPaymentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBonusPaymentsPublisher(MTurkAsyncClient client, ListBonusPaymentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBonusPaymentsPublisher(MTurkAsyncClient client, ListBonusPaymentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBonusPaymentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBonusPaymentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBonusPaymentsResponseFetcher
    implements AsyncPageFetcher<ListBonusPaymentsResponse> {
        private ListBonusPaymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListBonusPaymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBonusPaymentsResponse> nextPage(ListBonusPaymentsResponse previousPage) {
            if (previousPage == null) {
                return ListBonusPaymentsPublisher.this.client.listBonusPayments(ListBonusPaymentsPublisher.this.firstRequest);
            }
            return ListBonusPaymentsPublisher.this.client.listBonusPayments((ListBonusPaymentsRequest)((Object)ListBonusPaymentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

