/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EventType {
    ASSIGNMENT_ACCEPTED("AssignmentAccepted"),
    ASSIGNMENT_ABANDONED("AssignmentAbandoned"),
    ASSIGNMENT_RETURNED("AssignmentReturned"),
    ASSIGNMENT_SUBMITTED("AssignmentSubmitted"),
    ASSIGNMENT_REJECTED("AssignmentRejected"),
    ASSIGNMENT_APPROVED("AssignmentApproved"),
    HIT_CREATED("HITCreated"),
    HIT_EXPIRED("HITExpired"),
    HIT_REVIEWABLE("HITReviewable"),
    HIT_EXTENDED("HITExtended"),
    HIT_DISPOSED("HITDisposed"),
    PING("Ping"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EventType> VALUE_MAP;
    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
    }
}

