/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.BonusPayment;
import software.amazon.awssdk.services.mturk.model.BonusPaymentListCopier;
import software.amazon.awssdk.services.mturk.model.MTurkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBonusPaymentsResponse
extends MTurkResponse
implements ToCopyableBuilder<Builder, ListBonusPaymentsResponse> {
    private static final SdkField<Integer> NUM_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumResults").getter(ListBonusPaymentsResponse.getter(ListBonusPaymentsResponse::numResults)).setter(ListBonusPaymentsResponse.setter(Builder::numResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListBonusPaymentsResponse.getter(ListBonusPaymentsResponse::nextToken)).setter(ListBonusPaymentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<BonusPayment>> BONUS_PAYMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BonusPayments").getter(ListBonusPaymentsResponse.getter(ListBonusPaymentsResponse::bonusPayments)).setter(ListBonusPaymentsResponse.setter(Builder::bonusPayments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BonusPayments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BonusPayment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_RESULTS_FIELD, NEXT_TOKEN_FIELD, BONUS_PAYMENTS_FIELD));
    private final Integer numResults;
    private final String nextToken;
    private final List<BonusPayment> bonusPayments;

    private ListBonusPaymentsResponse(BuilderImpl builder) {
        super(builder);
        this.numResults = builder.numResults;
        this.nextToken = builder.nextToken;
        this.bonusPayments = builder.bonusPayments;
    }

    public final Integer numResults() {
        return this.numResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasBonusPayments() {
        return this.bonusPayments != null && !(this.bonusPayments instanceof SdkAutoConstructList);
    }

    public final List<BonusPayment> bonusPayments() {
        return this.bonusPayments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.numResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBonusPayments() ? this.bonusPayments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBonusPaymentsResponse)) {
            return false;
        }
        ListBonusPaymentsResponse other = (ListBonusPaymentsResponse)((Object)obj);
        return Objects.equals(this.numResults(), other.numResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasBonusPayments() == other.hasBonusPayments() && Objects.equals(this.bonusPayments(), other.bonusPayments());
    }

    public final String toString() {
        return ToString.builder((String)"ListBonusPaymentsResponse").add("NumResults", (Object)this.numResults()).add("NextToken", (Object)this.nextToken()).add("BonusPayments", this.hasBonusPayments() ? this.bonusPayments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumResults": {
                return Optional.ofNullable(clazz.cast(this.numResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "BonusPayments": {
                return Optional.ofNullable(clazz.cast(this.bonusPayments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBonusPaymentsResponse, T> g) {
        return obj -> g.apply((ListBonusPaymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkResponse.BuilderImpl
    implements Builder {
        private Integer numResults;
        private String nextToken;
        private List<BonusPayment> bonusPayments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBonusPaymentsResponse model) {
            super(model);
            this.numResults(model.numResults);
            this.nextToken(model.nextToken);
            this.bonusPayments(model.bonusPayments);
        }

        public final Integer getNumResults() {
            return this.numResults;
        }

        public final void setNumResults(Integer numResults) {
            this.numResults = numResults;
        }

        @Override
        public final Builder numResults(Integer numResults) {
            this.numResults = numResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BonusPayment.Builder> getBonusPayments() {
            List<BonusPayment.Builder> result = BonusPaymentListCopier.copyToBuilder(this.bonusPayments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBonusPayments(Collection<BonusPayment.BuilderImpl> bonusPayments) {
            this.bonusPayments = BonusPaymentListCopier.copyFromBuilder(bonusPayments);
        }

        @Override
        public final Builder bonusPayments(Collection<BonusPayment> bonusPayments) {
            this.bonusPayments = BonusPaymentListCopier.copy(bonusPayments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bonusPayments(BonusPayment ... bonusPayments) {
            this.bonusPayments(Arrays.asList(bonusPayments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bonusPayments(Consumer<BonusPayment.Builder> ... bonusPayments) {
            this.bonusPayments(Stream.of(bonusPayments).map(c -> (BonusPayment)((BonusPayment.Builder)BonusPayment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBonusPaymentsResponse build() {
            return new ListBonusPaymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBonusPaymentsResponse> {
        public Builder numResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder bonusPayments(Collection<BonusPayment> var1);

        public Builder bonusPayments(BonusPayment ... var1);

        public Builder bonusPayments(Consumer<BonusPayment.Builder> ... var1);
    }
}

