/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventType {
    ASSIGNMENT_ACCEPTED("AssignmentAccepted"),
    ASSIGNMENT_ABANDONED("AssignmentAbandoned"),
    ASSIGNMENT_RETURNED("AssignmentReturned"),
    ASSIGNMENT_SUBMITTED("AssignmentSubmitted"),
    ASSIGNMENT_REJECTED("AssignmentRejected"),
    ASSIGNMENT_APPROVED("AssignmentApproved"),
    HIT_CREATED("HITCreated"),
    HIT_EXPIRED("HITExpired"),
    HIT_REVIEWABLE("HITReviewable"),
    HIT_EXTENDED("HITExtended"),
    HIT_DISPOSED("HITDisposed"),
    PING("Ping"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventType> knownValues() {
        return Stream.of(EventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

