/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendBonusRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, SendBonusRequest> {
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerId").getter(SendBonusRequest.getter(SendBonusRequest::workerId)).setter(SendBonusRequest.setter(Builder::workerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerId").build()}).build();
    private static final SdkField<String> BONUS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BonusAmount").getter(SendBonusRequest.getter(SendBonusRequest::bonusAmount)).setter(SendBonusRequest.setter(Builder::bonusAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BonusAmount").build()}).build();
    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentId").getter(SendBonusRequest.getter(SendBonusRequest::assignmentId)).setter(SendBonusRequest.setter(Builder::assignmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(SendBonusRequest.getter(SendBonusRequest::reason)).setter(SendBonusRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<String> UNIQUE_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UniqueRequestToken").getter(SendBonusRequest.getter(SendBonusRequest::uniqueRequestToken)).setter(SendBonusRequest.setter(Builder::uniqueRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_ID_FIELD, BONUS_AMOUNT_FIELD, ASSIGNMENT_ID_FIELD, REASON_FIELD, UNIQUE_REQUEST_TOKEN_FIELD));
    private final String workerId;
    private final String bonusAmount;
    private final String assignmentId;
    private final String reason;
    private final String uniqueRequestToken;

    private SendBonusRequest(BuilderImpl builder) {
        super(builder);
        this.workerId = builder.workerId;
        this.bonusAmount = builder.bonusAmount;
        this.assignmentId = builder.assignmentId;
        this.reason = builder.reason;
        this.uniqueRequestToken = builder.uniqueRequestToken;
    }

    public String workerId() {
        return this.workerId;
    }

    public String bonusAmount() {
        return this.bonusAmount;
    }

    public String assignmentId() {
        return this.assignmentId;
    }

    public String reason() {
        return this.reason;
    }

    public String uniqueRequestToken() {
        return this.uniqueRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bonusAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBonusRequest)) {
            return false;
        }
        SendBonusRequest other = (SendBonusRequest)((Object)obj);
        return Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.bonusAmount(), other.bonusAmount()) && Objects.equals(this.assignmentId(), other.assignmentId()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.uniqueRequestToken(), other.uniqueRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"SendBonusRequest").add("WorkerId", (Object)this.workerId()).add("BonusAmount", (Object)this.bonusAmount()).add("AssignmentId", (Object)this.assignmentId()).add("Reason", (Object)this.reason()).add("UniqueRequestToken", (Object)this.uniqueRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "BonusAmount": {
                return Optional.ofNullable(clazz.cast(this.bonusAmount()));
            }
            case "AssignmentId": {
                return Optional.ofNullable(clazz.cast(this.assignmentId()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "UniqueRequestToken": {
                return Optional.ofNullable(clazz.cast(this.uniqueRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendBonusRequest, T> g) {
        return obj -> g.apply((SendBonusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String workerId;
        private String bonusAmount;
        private String assignmentId;
        private String reason;
        private String uniqueRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendBonusRequest model) {
            super(model);
            this.workerId(model.workerId);
            this.bonusAmount(model.bonusAmount);
            this.assignmentId(model.assignmentId);
            this.reason(model.reason);
            this.uniqueRequestToken(model.uniqueRequestToken);
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        public final String getBonusAmount() {
            return this.bonusAmount;
        }

        @Override
        public final Builder bonusAmount(String bonusAmount) {
            this.bonusAmount = bonusAmount;
            return this;
        }

        public final void setBonusAmount(String bonusAmount) {
            this.bonusAmount = bonusAmount;
        }

        public final String getAssignmentId() {
            return this.assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final String getUniqueRequestToken() {
            return this.uniqueRequestToken;
        }

        @Override
        public final Builder uniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
            return this;
        }

        public final void setUniqueRequestToken(String uniqueRequestToken) {
            this.uniqueRequestToken = uniqueRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendBonusRequest build() {
            return new SendBonusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendBonusRequest> {
        public Builder workerId(String var1);

        public Builder bonusAmount(String var1);

        public Builder assignmentId(String var1);

        public Builder reason(String var1);

        public Builder uniqueRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

