/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.mturk.MTurkClient;
import software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestRequest;
import software.amazon.awssdk.services.mturk.model.AcceptQualificationRequestResponse;
import software.amazon.awssdk.services.mturk.model.ApproveAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.ApproveAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerRequest;
import software.amazon.awssdk.services.mturk.model.AssociateQualificationWithWorkerResponse;
import software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.CreateAdditionalAssignmentsForHitResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateHitWithHitTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.CreateQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.CreateWorkerBlockRequest;
import software.amazon.awssdk.services.mturk.model.CreateWorkerBlockResponse;
import software.amazon.awssdk.services.mturk.model.DeleteHitRequest;
import software.amazon.awssdk.services.mturk.model.DeleteHitResponse;
import software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.DeleteQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockRequest;
import software.amazon.awssdk.services.mturk.model.DeleteWorkerBlockResponse;
import software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerRequest;
import software.amazon.awssdk.services.mturk.model.DisassociateQualificationFromWorkerResponse;
import software.amazon.awssdk.services.mturk.model.GetAccountBalanceRequest;
import software.amazon.awssdk.services.mturk.model.GetAccountBalanceResponse;
import software.amazon.awssdk.services.mturk.model.GetAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.GetAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.GetFileUploadUrlRequest;
import software.amazon.awssdk.services.mturk.model.GetFileUploadUrlResponse;
import software.amazon.awssdk.services.mturk.model.GetHitRequest;
import software.amazon.awssdk.services.mturk.model.GetHitResponse;
import software.amazon.awssdk.services.mturk.model.GetQualificationScoreRequest;
import software.amazon.awssdk.services.mturk.model.GetQualificationScoreResponse;
import software.amazon.awssdk.services.mturk.model.GetQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.GetQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListAssignmentsForHitResponse;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsRequest;
import software.amazon.awssdk.services.mturk.model.ListBonusPaymentsResponse;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsForQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.ListHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListHiTsResponse;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationRequestsResponse;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesRequest;
import software.amazon.awssdk.services.mturk.model.ListQualificationTypesResponse;
import software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewPolicyResultsForHitResponse;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsRequest;
import software.amazon.awssdk.services.mturk.model.ListReviewableHiTsResponse;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkerBlocksResponse;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.ListWorkersWithQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.model.MTurkException;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersRequest;
import software.amazon.awssdk.services.mturk.model.NotifyWorkersResponse;
import software.amazon.awssdk.services.mturk.model.RejectAssignmentRequest;
import software.amazon.awssdk.services.mturk.model.RejectAssignmentResponse;
import software.amazon.awssdk.services.mturk.model.RejectQualificationRequestRequest;
import software.amazon.awssdk.services.mturk.model.RejectQualificationRequestResponse;
import software.amazon.awssdk.services.mturk.model.RequestErrorException;
import software.amazon.awssdk.services.mturk.model.SendBonusRequest;
import software.amazon.awssdk.services.mturk.model.SendBonusResponse;
import software.amazon.awssdk.services.mturk.model.SendTestEventNotificationRequest;
import software.amazon.awssdk.services.mturk.model.SendTestEventNotificationResponse;
import software.amazon.awssdk.services.mturk.model.ServiceException;
import software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitRequest;
import software.amazon.awssdk.services.mturk.model.UpdateExpirationForHitResponse;
import software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusRequest;
import software.amazon.awssdk.services.mturk.model.UpdateHitReviewStatusResponse;
import software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitRequest;
import software.amazon.awssdk.services.mturk.model.UpdateHitTypeOfHitResponse;
import software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsRequest;
import software.amazon.awssdk.services.mturk.model.UpdateNotificationSettingsResponse;
import software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeRequest;
import software.amazon.awssdk.services.mturk.model.UpdateQualificationTypeResponse;
import software.amazon.awssdk.services.mturk.paginators.ListAssignmentsForHITIterable;
import software.amazon.awssdk.services.mturk.paginators.ListBonusPaymentsIterable;
import software.amazon.awssdk.services.mturk.paginators.ListHITsForQualificationTypeIterable;
import software.amazon.awssdk.services.mturk.paginators.ListHITsIterable;
import software.amazon.awssdk.services.mturk.paginators.ListQualificationRequestsIterable;
import software.amazon.awssdk.services.mturk.paginators.ListQualificationTypesIterable;
import software.amazon.awssdk.services.mturk.paginators.ListReviewPolicyResultsForHITIterable;
import software.amazon.awssdk.services.mturk.paginators.ListReviewableHITsIterable;
import software.amazon.awssdk.services.mturk.paginators.ListWorkerBlocksIterable;
import software.amazon.awssdk.services.mturk.paginators.ListWorkersWithQualificationTypeIterable;
import software.amazon.awssdk.services.mturk.transform.AcceptQualificationRequestRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ApproveAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.AssociateQualificationWithWorkerRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateAdditionalAssignmentsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateHitWithHitTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.CreateWorkerBlockRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DeleteWorkerBlockRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.DisassociateQualificationFromWorkerRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetAccountBalanceRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetFileUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetQualificationScoreRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.GetQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListAssignmentsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListBonusPaymentsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListHiTsForQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListHiTsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListQualificationRequestsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListQualificationTypesRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListReviewPolicyResultsForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListReviewableHiTsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListWorkerBlocksRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.ListWorkersWithQualificationTypeRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.NotifyWorkersRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.RejectAssignmentRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.RejectQualificationRequestRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.SendBonusRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.SendTestEventNotificationRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateExpirationForHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateHitReviewStatusRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateHitTypeOfHitRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateNotificationSettingsRequestMarshaller;
import software.amazon.awssdk.services.mturk.transform.UpdateQualificationTypeRequestMarshaller;

@SdkInternalApi
final class DefaultMTurkClient
implements MTurkClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMTurkClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "mturk-requester";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptQualificationRequestResponse acceptQualificationRequest(AcceptQualificationRequestRequest acceptQualificationRequestRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptQualificationRequestResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptQualificationRequest");
            AcceptQualificationRequestResponse acceptQualificationRequestResponse = (AcceptQualificationRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptQualificationRequest").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)acceptQualificationRequestRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AcceptQualificationRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptQualificationRequestResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, acceptQualificationRequestRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApproveAssignmentResponse approveAssignment(ApproveAssignmentRequest approveAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ApproveAssignmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApproveAssignment");
            ApproveAssignmentResponse approveAssignmentResponse = (ApproveAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApproveAssignment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)approveAssignmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ApproveAssignmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return approveAssignmentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, approveAssignmentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateQualificationWithWorkerResponse associateQualificationWithWorker(AssociateQualificationWithWorkerRequest associateQualificationWithWorkerRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateQualificationWithWorkerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateQualificationWithWorker");
            AssociateQualificationWithWorkerResponse associateQualificationWithWorkerResponse = (AssociateQualificationWithWorkerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateQualificationWithWorker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateQualificationWithWorkerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AssociateQualificationWithWorkerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateQualificationWithWorkerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, associateQualificationWithWorkerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAdditionalAssignmentsForHitResponse createAdditionalAssignmentsForHIT(CreateAdditionalAssignmentsForHitRequest createAdditionalAssignmentsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAdditionalAssignmentsForHitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAdditionalAssignmentsForHIT");
            CreateAdditionalAssignmentsForHitResponse createAdditionalAssignmentsForHitResponse = (CreateAdditionalAssignmentsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAdditionalAssignmentsForHIT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAdditionalAssignmentsForHitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAdditionalAssignmentsForHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAdditionalAssignmentsForHitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, createAdditionalAssignmentsForHitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHitResponse createHIT(CreateHitRequest createHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHIT");
            CreateHitResponse createHitResponse = (CreateHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHIT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, createHitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHitTypeResponse createHITType(CreateHitTypeRequest createHitTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHitTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHITType");
            CreateHitTypeResponse createHitTypeResponse = (CreateHitTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHITType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHitTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateHitTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHitTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, createHitTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHitWithHitTypeResponse createHITWithHITType(CreateHitWithHitTypeRequest createHitWithHitTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHitWithHitTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHITWithHITType");
            CreateHitWithHitTypeResponse createHitWithHitTypeResponse = (CreateHitWithHitTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHITWithHITType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHitWithHitTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateHitWithHitTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createHitWithHitTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, createHitWithHitTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateQualificationTypeResponse createQualificationType(CreateQualificationTypeRequest createQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateQualificationTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateQualificationType");
            CreateQualificationTypeResponse createQualificationTypeResponse = (CreateQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateQualificationType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createQualificationTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createQualificationTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, createQualificationTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkerBlockResponse createWorkerBlock(CreateWorkerBlockRequest createWorkerBlockRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkerBlockResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkerBlock");
            CreateWorkerBlockResponse createWorkerBlockResponse = (CreateWorkerBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkerBlock").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkerBlockRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkerBlockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkerBlockResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, createWorkerBlockRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHitResponse deleteHIT(DeleteHitRequest deleteHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteHitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHIT");
            DeleteHitResponse deleteHitResponse = (DeleteHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHIT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteHitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, deleteHitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteQualificationTypeResponse deleteQualificationType(DeleteQualificationTypeRequest deleteQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteQualificationTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteQualificationType");
            DeleteQualificationTypeResponse deleteQualificationTypeResponse = (DeleteQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQualificationType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteQualificationTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteQualificationTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, deleteQualificationTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkerBlockResponse deleteWorkerBlock(DeleteWorkerBlockRequest deleteWorkerBlockRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkerBlockResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkerBlock");
            DeleteWorkerBlockResponse deleteWorkerBlockResponse = (DeleteWorkerBlockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkerBlock").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkerBlockRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkerBlockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkerBlockResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkerBlockRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateQualificationFromWorkerResponse disassociateQualificationFromWorker(DisassociateQualificationFromWorkerRequest disassociateQualificationFromWorkerRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateQualificationFromWorkerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateQualificationFromWorker");
            DisassociateQualificationFromWorkerResponse disassociateQualificationFromWorkerResponse = (DisassociateQualificationFromWorkerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateQualificationFromWorker").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateQualificationFromWorkerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateQualificationFromWorkerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateQualificationFromWorkerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, disassociateQualificationFromWorkerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountBalanceResponse getAccountBalance(GetAccountBalanceRequest getAccountBalanceRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAccountBalanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountBalance");
            GetAccountBalanceResponse getAccountBalanceResponse = (GetAccountBalanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountBalance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAccountBalanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountBalanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAccountBalanceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, getAccountBalanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssignmentResponse getAssignment(GetAssignmentRequest getAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssignmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssignment");
            GetAssignmentResponse getAssignmentResponse = (GetAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssignment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAssignmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAssignmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssignmentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, getAssignmentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFileUploadUrlResponse getFileUploadURL(GetFileUploadUrlRequest getFileUploadUrlRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFileUploadUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFileUploadURL");
            GetFileUploadUrlResponse getFileUploadUrlResponse = (GetFileUploadUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFileUploadURL").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFileUploadUrlRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetFileUploadUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFileUploadUrlResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, getFileUploadUrlRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHitResponse getHIT(GetHitRequest getHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHIT");
            GetHitResponse getHitResponse = (GetHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHIT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getHitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, getHitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQualificationScoreResponse getQualificationScore(GetQualificationScoreRequest getQualificationScoreRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQualificationScoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQualificationScore");
            GetQualificationScoreResponse getQualificationScoreResponse = (GetQualificationScoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQualificationScore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQualificationScoreRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetQualificationScoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQualificationScoreResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, getQualificationScoreRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQualificationTypeResponse getQualificationType(GetQualificationTypeRequest getQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQualificationTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQualificationType");
            GetQualificationTypeResponse getQualificationTypeResponse = (GetQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQualificationType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getQualificationTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQualificationTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, getQualificationTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAssignmentsForHitResponse listAssignmentsForHIT(ListAssignmentsForHitRequest listAssignmentsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAssignmentsForHitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAssignmentsForHIT");
            ListAssignmentsForHitResponse listAssignmentsForHitResponse = (ListAssignmentsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAssignmentsForHIT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAssignmentsForHitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAssignmentsForHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAssignmentsForHitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listAssignmentsForHitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListAssignmentsForHITIterable listAssignmentsForHITPaginator(ListAssignmentsForHitRequest listAssignmentsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListAssignmentsForHITIterable(this, this.applyPaginatorUserAgent(listAssignmentsForHitRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBonusPaymentsResponse listBonusPayments(ListBonusPaymentsRequest listBonusPaymentsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBonusPaymentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBonusPayments");
            ListBonusPaymentsResponse listBonusPaymentsResponse = (ListBonusPaymentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBonusPayments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listBonusPaymentsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListBonusPaymentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listBonusPaymentsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listBonusPaymentsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListBonusPaymentsIterable listBonusPaymentsPaginator(ListBonusPaymentsRequest listBonusPaymentsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListBonusPaymentsIterable(this, this.applyPaginatorUserAgent(listBonusPaymentsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHiTsResponse listHITs(ListHiTsRequest listHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHiTsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHITs");
            ListHiTsResponse listHiTsResponse = (ListHiTsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHITs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHiTsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListHiTsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listHiTsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listHiTsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListHITsIterable listHITsPaginator(ListHiTsRequest listHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListHITsIterable(this, this.applyPaginatorUserAgent(listHiTsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHiTsForQualificationTypeResponse listHITsForQualificationType(ListHiTsForQualificationTypeRequest listHiTsForQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHiTsForQualificationTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHITsForQualificationType");
            ListHiTsForQualificationTypeResponse listHiTsForQualificationTypeResponse = (ListHiTsForQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHITsForQualificationType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHiTsForQualificationTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListHiTsForQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listHiTsForQualificationTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listHiTsForQualificationTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListHITsForQualificationTypeIterable listHITsForQualificationTypePaginator(ListHiTsForQualificationTypeRequest listHiTsForQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListHITsForQualificationTypeIterable(this, this.applyPaginatorUserAgent(listHiTsForQualificationTypeRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQualificationRequestsResponse listQualificationRequests(ListQualificationRequestsRequest listQualificationRequestsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQualificationRequestsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQualificationRequests");
            ListQualificationRequestsResponse listQualificationRequestsResponse = (ListQualificationRequestsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQualificationRequests").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQualificationRequestsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListQualificationRequestsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listQualificationRequestsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listQualificationRequestsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListQualificationRequestsIterable listQualificationRequestsPaginator(ListQualificationRequestsRequest listQualificationRequestsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListQualificationRequestsIterable(this, this.applyPaginatorUserAgent(listQualificationRequestsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQualificationTypesResponse listQualificationTypes(ListQualificationTypesRequest listQualificationTypesRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListQualificationTypesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQualificationTypes");
            ListQualificationTypesResponse listQualificationTypesResponse = (ListQualificationTypesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQualificationTypes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listQualificationTypesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListQualificationTypesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listQualificationTypesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listQualificationTypesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListQualificationTypesIterable listQualificationTypesPaginator(ListQualificationTypesRequest listQualificationTypesRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListQualificationTypesIterable(this, this.applyPaginatorUserAgent(listQualificationTypesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReviewPolicyResultsForHitResponse listReviewPolicyResultsForHIT(ListReviewPolicyResultsForHitRequest listReviewPolicyResultsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReviewPolicyResultsForHitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReviewPolicyResultsForHIT");
            ListReviewPolicyResultsForHitResponse listReviewPolicyResultsForHitResponse = (ListReviewPolicyResultsForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReviewPolicyResultsForHIT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReviewPolicyResultsForHitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListReviewPolicyResultsForHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReviewPolicyResultsForHitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listReviewPolicyResultsForHitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListReviewPolicyResultsForHITIterable listReviewPolicyResultsForHITPaginator(ListReviewPolicyResultsForHitRequest listReviewPolicyResultsForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListReviewPolicyResultsForHITIterable(this, this.applyPaginatorUserAgent(listReviewPolicyResultsForHitRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReviewableHiTsResponse listReviewableHITs(ListReviewableHiTsRequest listReviewableHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReviewableHiTsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReviewableHITs");
            ListReviewableHiTsResponse listReviewableHiTsResponse = (ListReviewableHiTsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReviewableHITs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listReviewableHiTsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListReviewableHiTsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReviewableHiTsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listReviewableHiTsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListReviewableHITsIterable listReviewableHITsPaginator(ListReviewableHiTsRequest listReviewableHiTsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListReviewableHITsIterable(this, this.applyPaginatorUserAgent(listReviewableHiTsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkerBlocksResponse listWorkerBlocks(ListWorkerBlocksRequest listWorkerBlocksRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkerBlocksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkerBlocks");
            ListWorkerBlocksResponse listWorkerBlocksResponse = (ListWorkerBlocksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkerBlocks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkerBlocksRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkerBlocksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkerBlocksResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listWorkerBlocksRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListWorkerBlocksIterable listWorkerBlocksPaginator(ListWorkerBlocksRequest listWorkerBlocksRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListWorkerBlocksIterable(this, this.applyPaginatorUserAgent(listWorkerBlocksRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkersWithQualificationTypeResponse listWorkersWithQualificationType(ListWorkersWithQualificationTypeRequest listWorkersWithQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkersWithQualificationTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkersWithQualificationType");
            ListWorkersWithQualificationTypeResponse listWorkersWithQualificationTypeResponse = (ListWorkersWithQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkersWithQualificationType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkersWithQualificationTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkersWithQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkersWithQualificationTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, listWorkersWithQualificationTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListWorkersWithQualificationTypeIterable listWorkersWithQualificationTypePaginator(ListWorkersWithQualificationTypeRequest listWorkersWithQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        return new ListWorkersWithQualificationTypeIterable(this, this.applyPaginatorUserAgent(listWorkersWithQualificationTypeRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyWorkersResponse notifyWorkers(NotifyWorkersRequest notifyWorkersRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, NotifyWorkersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"NotifyWorkers");
            NotifyWorkersResponse notifyWorkersResponse = (NotifyWorkersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("NotifyWorkers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)notifyWorkersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new NotifyWorkersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return notifyWorkersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, notifyWorkersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectAssignmentResponse rejectAssignment(RejectAssignmentRequest rejectAssignmentRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectAssignmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectAssignment");
            RejectAssignmentResponse rejectAssignmentResponse = (RejectAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectAssignment").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectAssignmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RejectAssignmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectAssignmentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, rejectAssignmentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectQualificationRequestResponse rejectQualificationRequest(RejectQualificationRequestRequest rejectQualificationRequestRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectQualificationRequestResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectQualificationRequest");
            RejectQualificationRequestResponse rejectQualificationRequestResponse = (RejectQualificationRequestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectQualificationRequest").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)rejectQualificationRequestRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new RejectQualificationRequestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectQualificationRequestResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, rejectQualificationRequestRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendBonusResponse sendBonus(SendBonusRequest sendBonusRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendBonusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendBonus");
            SendBonusResponse sendBonusResponse = (SendBonusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendBonus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendBonusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SendBonusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendBonusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, sendBonusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTestEventNotificationResponse sendTestEventNotification(SendTestEventNotificationRequest sendTestEventNotificationRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendTestEventNotificationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendTestEventNotification");
            SendTestEventNotificationResponse sendTestEventNotificationResponse = (SendTestEventNotificationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendTestEventNotification").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendTestEventNotificationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new SendTestEventNotificationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendTestEventNotificationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, sendTestEventNotificationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateExpirationForHitResponse updateExpirationForHIT(UpdateExpirationForHitRequest updateExpirationForHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateExpirationForHitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateExpirationForHIT");
            UpdateExpirationForHitResponse updateExpirationForHitResponse = (UpdateExpirationForHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateExpirationForHIT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateExpirationForHitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateExpirationForHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateExpirationForHitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, updateExpirationForHitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateHitReviewStatusResponse updateHITReviewStatus(UpdateHitReviewStatusRequest updateHitReviewStatusRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateHitReviewStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHITReviewStatus");
            UpdateHitReviewStatusResponse updateHitReviewStatusResponse = (UpdateHitReviewStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHITReviewStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateHitReviewStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateHitReviewStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateHitReviewStatusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, updateHitReviewStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateHitTypeOfHitResponse updateHITTypeOfHIT(UpdateHitTypeOfHitRequest updateHitTypeOfHitRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateHitTypeOfHitResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHITTypeOfHIT");
            UpdateHitTypeOfHitResponse updateHitTypeOfHitResponse = (UpdateHitTypeOfHitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHITTypeOfHIT").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateHitTypeOfHitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateHitTypeOfHitRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateHitTypeOfHitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, updateHitTypeOfHitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNotificationSettingsResponse updateNotificationSettings(UpdateNotificationSettingsRequest updateNotificationSettingsRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotificationSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNotificationSettings");
            UpdateNotificationSettingsResponse updateNotificationSettingsResponse = (UpdateNotificationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotificationSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateNotificationSettingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNotificationSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNotificationSettingsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, updateNotificationSettingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateQualificationTypeResponse updateQualificationType(UpdateQualificationTypeRequest updateQualificationTypeRequest) throws ServiceException, RequestErrorException, AwsServiceException, SdkClientException, MTurkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateQualificationTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MTurk");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateQualificationType");
            UpdateQualificationTypeResponse updateQualificationTypeResponse = (UpdateQualificationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateQualificationType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateQualificationTypeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateQualificationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateQualificationTypeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultMTurkClient.resolveMetricPublishers(this.clientConfiguration, updateQualificationTypeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MTurkException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceFault").exceptionBuilderSupplier(ServiceException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestError").exceptionBuilderSupplier(RequestErrorException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends MTurkRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.61").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MTurkRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

