/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccountBalanceResponse extends MTurkResponse implements
        ToCopyableBuilder<GetAccountBalanceResponse.Builder, GetAccountBalanceResponse> {
    private static final SdkField<String> AVAILABLE_BALANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAccountBalanceResponse::availableBalance)).setter(setter(Builder::availableBalance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableBalance").build()).build();

    private static final SdkField<String> ON_HOLD_BALANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetAccountBalanceResponse::onHoldBalance)).setter(setter(Builder::onHoldBalance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnHoldBalance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_BALANCE_FIELD,
            ON_HOLD_BALANCE_FIELD));

    private final String availableBalance;

    private final String onHoldBalance;

    private GetAccountBalanceResponse(BuilderImpl builder) {
        super(builder);
        this.availableBalance = builder.availableBalance;
        this.onHoldBalance = builder.onHoldBalance;
    }

    /**
     * Returns the value of the AvailableBalance property for this object.
     * 
     * @return The value of the AvailableBalance property for this object.
     */
    public String availableBalance() {
        return availableBalance;
    }

    /**
     * Returns the value of the OnHoldBalance property for this object.
     * 
     * @return The value of the OnHoldBalance property for this object.
     */
    public String onHoldBalance() {
        return onHoldBalance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(availableBalance());
        hashCode = 31 * hashCode + Objects.hashCode(onHoldBalance());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountBalanceResponse)) {
            return false;
        }
        GetAccountBalanceResponse other = (GetAccountBalanceResponse) obj;
        return Objects.equals(availableBalance(), other.availableBalance())
                && Objects.equals(onHoldBalance(), other.onHoldBalance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAccountBalanceResponse").add("AvailableBalance", availableBalance())
                .add("OnHoldBalance", onHoldBalance()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailableBalance":
            return Optional.ofNullable(clazz.cast(availableBalance()));
        case "OnHoldBalance":
            return Optional.ofNullable(clazz.cast(onHoldBalance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountBalanceResponse, T> g) {
        return obj -> g.apply((GetAccountBalanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAccountBalanceResponse> {
        /**
         * Sets the value of the AvailableBalance property for this object.
         *
         * @param availableBalance
         *        The new value for the AvailableBalance property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableBalance(String availableBalance);

        /**
         * Sets the value of the OnHoldBalance property for this object.
         *
         * @param onHoldBalance
         *        The new value for the OnHoldBalance property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onHoldBalance(String onHoldBalance);
    }

    static final class BuilderImpl extends MTurkResponse.BuilderImpl implements Builder {
        private String availableBalance;

        private String onHoldBalance;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountBalanceResponse model) {
            super(model);
            availableBalance(model.availableBalance);
            onHoldBalance(model.onHoldBalance);
        }

        public final String getAvailableBalance() {
            return availableBalance;
        }

        @Override
        public final Builder availableBalance(String availableBalance) {
            this.availableBalance = availableBalance;
            return this;
        }

        public final void setAvailableBalance(String availableBalance) {
            this.availableBalance = availableBalance;
        }

        public final String getOnHoldBalance() {
            return onHoldBalance;
        }

        @Override
        public final Builder onHoldBalance(String onHoldBalance) {
            this.onHoldBalance = onHoldBalance;
            return this;
        }

        public final void setOnHoldBalance(String onHoldBalance) {
            this.onHoldBalance = onHoldBalance;
        }

        @Override
        public GetAccountBalanceResponse build() {
            return new GetAccountBalanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
