/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApproveAssignmentRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, ApproveAssignmentRequest> {
    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApproveAssignmentRequest.getter(ApproveAssignmentRequest::assignmentId)).setter(ApproveAssignmentRequest.setter(Builder::assignmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()}).build();
    private static final SdkField<String> REQUESTER_FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApproveAssignmentRequest.getter(ApproveAssignmentRequest::requesterFeedback)).setter(ApproveAssignmentRequest.setter(Builder::requesterFeedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterFeedback").build()}).build();
    private static final SdkField<Boolean> OVERRIDE_REJECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ApproveAssignmentRequest.getter(ApproveAssignmentRequest::overrideRejection)).setter(ApproveAssignmentRequest.setter(Builder::overrideRejection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideRejection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_ID_FIELD, REQUESTER_FEEDBACK_FIELD, OVERRIDE_REJECTION_FIELD));
    private final String assignmentId;
    private final String requesterFeedback;
    private final Boolean overrideRejection;

    private ApproveAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.assignmentId = builder.assignmentId;
        this.requesterFeedback = builder.requesterFeedback;
        this.overrideRejection = builder.overrideRejection;
    }

    public String assignmentId() {
        return this.assignmentId;
    }

    public String requesterFeedback() {
        return this.requesterFeedback;
    }

    public Boolean overrideRejection() {
        return this.overrideRejection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterFeedback());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideRejection());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApproveAssignmentRequest)) {
            return false;
        }
        ApproveAssignmentRequest other = (ApproveAssignmentRequest)((Object)obj);
        return Objects.equals(this.assignmentId(), other.assignmentId()) && Objects.equals(this.requesterFeedback(), other.requesterFeedback()) && Objects.equals(this.overrideRejection(), other.overrideRejection());
    }

    public String toString() {
        return ToString.builder((String)"ApproveAssignmentRequest").add("AssignmentId", (Object)this.assignmentId()).add("RequesterFeedback", (Object)this.requesterFeedback()).add("OverrideRejection", (Object)this.overrideRejection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentId": {
                return Optional.ofNullable(clazz.cast(this.assignmentId()));
            }
            case "RequesterFeedback": {
                return Optional.ofNullable(clazz.cast(this.requesterFeedback()));
            }
            case "OverrideRejection": {
                return Optional.ofNullable(clazz.cast(this.overrideRejection()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApproveAssignmentRequest, T> g) {
        return obj -> g.apply((ApproveAssignmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String assignmentId;
        private String requesterFeedback;
        private Boolean overrideRejection;

        private BuilderImpl() {
        }

        private BuilderImpl(ApproveAssignmentRequest model) {
            super(model);
            this.assignmentId(model.assignmentId);
            this.requesterFeedback(model.requesterFeedback);
            this.overrideRejection(model.overrideRejection);
        }

        public final String getAssignmentId() {
            return this.assignmentId;
        }

        @Override
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        public final String getRequesterFeedback() {
            return this.requesterFeedback;
        }

        @Override
        public final Builder requesterFeedback(String requesterFeedback) {
            this.requesterFeedback = requesterFeedback;
            return this;
        }

        public final void setRequesterFeedback(String requesterFeedback) {
            this.requesterFeedback = requesterFeedback;
        }

        public final Boolean getOverrideRejection() {
            return this.overrideRejection;
        }

        @Override
        public final Builder overrideRejection(Boolean overrideRejection) {
            this.overrideRejection = overrideRejection;
            return this;
        }

        public final void setOverrideRejection(Boolean overrideRejection) {
            this.overrideRejection = overrideRejection;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApproveAssignmentRequest build() {
            return new ApproveAssignmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApproveAssignmentRequest> {
        public Builder assignmentId(String var1);

        public Builder requesterFeedback(String var1);

        public Builder overrideRejection(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

