/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.QualificationTypeStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QualificationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QualificationType> {
    private static final SdkField<String> QUALIFICATION_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationType.getter(QualificationType::qualificationTypeId)).setter(QualificationType.setter(Builder::qualificationTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(QualificationType.getter(QualificationType::creationTime)).setter(QualificationType.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationType.getter(QualificationType::name)).setter(QualificationType.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationType.getter(QualificationType::description)).setter(QualificationType.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationType.getter(QualificationType::keywords)).setter(QualificationType.setter(Builder::keywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keywords").build()}).build();
    private static final SdkField<String> QUALIFICATION_TYPE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationType.getter(QualificationType::qualificationTypeStatusAsString)).setter(QualificationType.setter(Builder::qualificationTypeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeStatus").build()}).build();
    private static final SdkField<String> TEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationType.getter(QualificationType::test)).setter(QualificationType.setter(Builder::test)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Test").build()}).build();
    private static final SdkField<Long> TEST_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(QualificationType.getter(QualificationType::testDurationInSeconds)).setter(QualificationType.setter(Builder::testDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestDurationInSeconds").build()}).build();
    private static final SdkField<String> ANSWER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QualificationType.getter(QualificationType::answerKey)).setter(QualificationType.setter(Builder::answerKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerKey").build()}).build();
    private static final SdkField<Long> RETRY_DELAY_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(QualificationType.getter(QualificationType::retryDelayInSeconds)).setter(QualificationType.setter(Builder::retryDelayInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryDelayInSeconds").build()}).build();
    private static final SdkField<Boolean> IS_REQUESTABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(QualificationType.getter(QualificationType::isRequestable)).setter(QualificationType.setter(Builder::isRequestable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRequestable").build()}).build();
    private static final SdkField<Boolean> AUTO_GRANTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(QualificationType.getter(QualificationType::autoGranted)).setter(QualificationType.setter(Builder::autoGranted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGranted").build()}).build();
    private static final SdkField<Integer> AUTO_GRANTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(QualificationType.getter(QualificationType::autoGrantedValue)).setter(QualificationType.setter(Builder::autoGrantedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoGrantedValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_TYPE_ID_FIELD, CREATION_TIME_FIELD, NAME_FIELD, DESCRIPTION_FIELD, KEYWORDS_FIELD, QUALIFICATION_TYPE_STATUS_FIELD, TEST_FIELD, TEST_DURATION_IN_SECONDS_FIELD, ANSWER_KEY_FIELD, RETRY_DELAY_IN_SECONDS_FIELD, IS_REQUESTABLE_FIELD, AUTO_GRANTED_FIELD, AUTO_GRANTED_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String qualificationTypeId;
    private final Instant creationTime;
    private final String name;
    private final String description;
    private final String keywords;
    private final String qualificationTypeStatus;
    private final String test;
    private final Long testDurationInSeconds;
    private final String answerKey;
    private final Long retryDelayInSeconds;
    private final Boolean isRequestable;
    private final Boolean autoGranted;
    private final Integer autoGrantedValue;

    private QualificationType(BuilderImpl builder) {
        this.qualificationTypeId = builder.qualificationTypeId;
        this.creationTime = builder.creationTime;
        this.name = builder.name;
        this.description = builder.description;
        this.keywords = builder.keywords;
        this.qualificationTypeStatus = builder.qualificationTypeStatus;
        this.test = builder.test;
        this.testDurationInSeconds = builder.testDurationInSeconds;
        this.answerKey = builder.answerKey;
        this.retryDelayInSeconds = builder.retryDelayInSeconds;
        this.isRequestable = builder.isRequestable;
        this.autoGranted = builder.autoGranted;
        this.autoGrantedValue = builder.autoGrantedValue;
    }

    public String qualificationTypeId() {
        return this.qualificationTypeId;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String keywords() {
        return this.keywords;
    }

    public QualificationTypeStatus qualificationTypeStatus() {
        return QualificationTypeStatus.fromValue(this.qualificationTypeStatus);
    }

    public String qualificationTypeStatusAsString() {
        return this.qualificationTypeStatus;
    }

    public String test() {
        return this.test;
    }

    public Long testDurationInSeconds() {
        return this.testDurationInSeconds;
    }

    public String answerKey() {
        return this.answerKey;
    }

    public Long retryDelayInSeconds() {
        return this.retryDelayInSeconds;
    }

    public Boolean isRequestable() {
        return this.isRequestable;
    }

    public Boolean autoGranted() {
        return this.autoGranted;
    }

    public Integer autoGrantedValue() {
        return this.autoGrantedValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.keywords());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.test());
        hashCode = 31 * hashCode + Objects.hashCode(this.testDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.answerKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryDelayInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRequestable());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGranted());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoGrantedValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualificationType)) {
            return false;
        }
        QualificationType other = (QualificationType)obj;
        return Objects.equals(this.qualificationTypeId(), other.qualificationTypeId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.keywords(), other.keywords()) && Objects.equals(this.qualificationTypeStatusAsString(), other.qualificationTypeStatusAsString()) && Objects.equals(this.test(), other.test()) && Objects.equals(this.testDurationInSeconds(), other.testDurationInSeconds()) && Objects.equals(this.answerKey(), other.answerKey()) && Objects.equals(this.retryDelayInSeconds(), other.retryDelayInSeconds()) && Objects.equals(this.isRequestable(), other.isRequestable()) && Objects.equals(this.autoGranted(), other.autoGranted()) && Objects.equals(this.autoGrantedValue(), other.autoGrantedValue());
    }

    public String toString() {
        return ToString.builder((String)"QualificationType").add("QualificationTypeId", (Object)this.qualificationTypeId()).add("CreationTime", (Object)this.creationTime()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Keywords", (Object)this.keywords()).add("QualificationTypeStatus", (Object)this.qualificationTypeStatusAsString()).add("Test", (Object)this.test()).add("TestDurationInSeconds", (Object)this.testDurationInSeconds()).add("AnswerKey", (Object)this.answerKey()).add("RetryDelayInSeconds", (Object)this.retryDelayInSeconds()).add("IsRequestable", (Object)this.isRequestable()).add("AutoGranted", (Object)this.autoGranted()).add("AutoGrantedValue", (Object)this.autoGrantedValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QualificationTypeId": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypeId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Keywords": {
                return Optional.ofNullable(clazz.cast(this.keywords()));
            }
            case "QualificationTypeStatus": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypeStatusAsString()));
            }
            case "Test": {
                return Optional.ofNullable(clazz.cast(this.test()));
            }
            case "TestDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.testDurationInSeconds()));
            }
            case "AnswerKey": {
                return Optional.ofNullable(clazz.cast(this.answerKey()));
            }
            case "RetryDelayInSeconds": {
                return Optional.ofNullable(clazz.cast(this.retryDelayInSeconds()));
            }
            case "IsRequestable": {
                return Optional.ofNullable(clazz.cast(this.isRequestable()));
            }
            case "AutoGranted": {
                return Optional.ofNullable(clazz.cast(this.autoGranted()));
            }
            case "AutoGrantedValue": {
                return Optional.ofNullable(clazz.cast(this.autoGrantedValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QualificationType, T> g) {
        return obj -> g.apply((QualificationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String qualificationTypeId;
        private Instant creationTime;
        private String name;
        private String description;
        private String keywords;
        private String qualificationTypeStatus;
        private String test;
        private Long testDurationInSeconds;
        private String answerKey;
        private Long retryDelayInSeconds;
        private Boolean isRequestable;
        private Boolean autoGranted;
        private Integer autoGrantedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(QualificationType model) {
            this.qualificationTypeId(model.qualificationTypeId);
            this.creationTime(model.creationTime);
            this.name(model.name);
            this.description(model.description);
            this.keywords(model.keywords);
            this.qualificationTypeStatus(model.qualificationTypeStatus);
            this.test(model.test);
            this.testDurationInSeconds(model.testDurationInSeconds);
            this.answerKey(model.answerKey);
            this.retryDelayInSeconds(model.retryDelayInSeconds);
            this.isRequestable(model.isRequestable);
            this.autoGranted(model.autoGranted);
            this.autoGrantedValue(model.autoGrantedValue);
        }

        public final String getQualificationTypeId() {
            return this.qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKeywords() {
            return this.keywords;
        }

        @Override
        public final Builder keywords(String keywords) {
            this.keywords = keywords;
            return this;
        }

        public final void setKeywords(String keywords) {
            this.keywords = keywords;
        }

        public final String getQualificationTypeStatus() {
            return this.qualificationTypeStatus;
        }

        @Override
        public final Builder qualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
            return this;
        }

        @Override
        public final Builder qualificationTypeStatus(QualificationTypeStatus qualificationTypeStatus) {
            this.qualificationTypeStatus(qualificationTypeStatus.toString());
            return this;
        }

        public final void setQualificationTypeStatus(String qualificationTypeStatus) {
            this.qualificationTypeStatus = qualificationTypeStatus;
        }

        public final String getTest() {
            return this.test;
        }

        @Override
        public final Builder test(String test) {
            this.test = test;
            return this;
        }

        public final void setTest(String test) {
            this.test = test;
        }

        public final Long getTestDurationInSeconds() {
            return this.testDurationInSeconds;
        }

        @Override
        public final Builder testDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
            return this;
        }

        public final void setTestDurationInSeconds(Long testDurationInSeconds) {
            this.testDurationInSeconds = testDurationInSeconds;
        }

        public final String getAnswerKey() {
            return this.answerKey;
        }

        @Override
        public final Builder answerKey(String answerKey) {
            this.answerKey = answerKey;
            return this;
        }

        public final void setAnswerKey(String answerKey) {
            this.answerKey = answerKey;
        }

        public final Long getRetryDelayInSeconds() {
            return this.retryDelayInSeconds;
        }

        @Override
        public final Builder retryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
            return this;
        }

        public final void setRetryDelayInSeconds(Long retryDelayInSeconds) {
            this.retryDelayInSeconds = retryDelayInSeconds;
        }

        public final Boolean getIsRequestable() {
            return this.isRequestable;
        }

        @Override
        public final Builder isRequestable(Boolean isRequestable) {
            this.isRequestable = isRequestable;
            return this;
        }

        public final void setIsRequestable(Boolean isRequestable) {
            this.isRequestable = isRequestable;
        }

        public final Boolean getAutoGranted() {
            return this.autoGranted;
        }

        @Override
        public final Builder autoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
            return this;
        }

        public final void setAutoGranted(Boolean autoGranted) {
            this.autoGranted = autoGranted;
        }

        public final Integer getAutoGrantedValue() {
            return this.autoGrantedValue;
        }

        @Override
        public final Builder autoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
            return this;
        }

        public final void setAutoGrantedValue(Integer autoGrantedValue) {
            this.autoGrantedValue = autoGrantedValue;
        }

        public QualificationType build() {
            return new QualificationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QualificationType> {
        public Builder qualificationTypeId(String var1);

        public Builder creationTime(Instant var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder keywords(String var1);

        public Builder qualificationTypeStatus(String var1);

        public Builder qualificationTypeStatus(QualificationTypeStatus var1);

        public Builder test(String var1);

        public Builder testDurationInSeconds(Long var1);

        public Builder answerKey(String var1);

        public Builder retryDelayInSeconds(Long var1);

        public Builder isRequestable(Boolean var1);

        public Builder autoGranted(Boolean var1);

        public Builder autoGrantedValue(Integer var1);
    }
}

