/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mturk.model.MTurkRequest;
import software.amazon.awssdk.services.mturk.model.ReviewPolicyLevel;
import software.amazon.awssdk.services.mturk.model.ReviewPolicyLevelListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReviewPolicyResultsForHitRequest
extends MTurkRequest
implements ToCopyableBuilder<Builder, ListReviewPolicyResultsForHitRequest> {
    private static final SdkField<String> HIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListReviewPolicyResultsForHitRequest.getter(ListReviewPolicyResultsForHitRequest::hitId)).setter(ListReviewPolicyResultsForHitRequest.setter(Builder::hitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()}).build();
    private static final SdkField<List<String>> POLICY_LEVELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListReviewPolicyResultsForHitRequest.getter(ListReviewPolicyResultsForHitRequest::policyLevelsAsStrings)).setter(ListReviewPolicyResultsForHitRequest.setter(Builder::policyLevelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyLevels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RETRIEVE_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListReviewPolicyResultsForHitRequest.getter(ListReviewPolicyResultsForHitRequest::retrieveActions)).setter(ListReviewPolicyResultsForHitRequest.setter(Builder::retrieveActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrieveActions").build()}).build();
    private static final SdkField<Boolean> RETRIEVE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListReviewPolicyResultsForHitRequest.getter(ListReviewPolicyResultsForHitRequest::retrieveResults)).setter(ListReviewPolicyResultsForHitRequest.setter(Builder::retrieveResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrieveResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListReviewPolicyResultsForHitRequest.getter(ListReviewPolicyResultsForHitRequest::nextToken)).setter(ListReviewPolicyResultsForHitRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListReviewPolicyResultsForHitRequest.getter(ListReviewPolicyResultsForHitRequest::maxResults)).setter(ListReviewPolicyResultsForHitRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_ID_FIELD, POLICY_LEVELS_FIELD, RETRIEVE_ACTIONS_FIELD, RETRIEVE_RESULTS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String hitId;
    private final List<String> policyLevels;
    private final Boolean retrieveActions;
    private final Boolean retrieveResults;
    private final String nextToken;
    private final Integer maxResults;

    private ListReviewPolicyResultsForHitRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.policyLevels = builder.policyLevels;
        this.retrieveActions = builder.retrieveActions;
        this.retrieveResults = builder.retrieveResults;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String hitId() {
        return this.hitId;
    }

    public List<ReviewPolicyLevel> policyLevels() {
        return TypeConverter.convert(this.policyLevels, ReviewPolicyLevel::fromValue);
    }

    public List<String> policyLevelsAsStrings() {
        return this.policyLevels;
    }

    public Boolean retrieveActions() {
        return this.retrieveActions;
    }

    public Boolean retrieveResults() {
        return this.retrieveResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyLevelsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieveActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrieveResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewPolicyResultsForHitRequest)) {
            return false;
        }
        ListReviewPolicyResultsForHitRequest other = (ListReviewPolicyResultsForHitRequest)((Object)obj);
        return Objects.equals(this.hitId(), other.hitId()) && Objects.equals(this.policyLevelsAsStrings(), other.policyLevelsAsStrings()) && Objects.equals(this.retrieveActions(), other.retrieveActions()) && Objects.equals(this.retrieveResults(), other.retrieveResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"ListReviewPolicyResultsForHitRequest").add("HITId", (Object)this.hitId()).add("PolicyLevels", this.policyLevelsAsStrings()).add("RetrieveActions", (Object)this.retrieveActions()).add("RetrieveResults", (Object)this.retrieveResults()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HITId": {
                return Optional.ofNullable(clazz.cast(this.hitId()));
            }
            case "PolicyLevels": {
                return Optional.ofNullable(clazz.cast(this.policyLevelsAsStrings()));
            }
            case "RetrieveActions": {
                return Optional.ofNullable(clazz.cast(this.retrieveActions()));
            }
            case "RetrieveResults": {
                return Optional.ofNullable(clazz.cast(this.retrieveResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReviewPolicyResultsForHitRequest, T> g) {
        return obj -> g.apply((ListReviewPolicyResultsForHitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MTurkRequest.BuilderImpl
    implements Builder {
        private String hitId;
        private List<String> policyLevels = DefaultSdkAutoConstructList.getInstance();
        private Boolean retrieveActions;
        private Boolean retrieveResults;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewPolicyResultsForHitRequest model) {
            super(model);
            this.hitId(model.hitId);
            this.policyLevelsWithStrings(model.policyLevels);
            this.retrieveActions(model.retrieveActions);
            this.retrieveResults(model.retrieveResults);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getHITId() {
            return this.hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final void setHITId(String hitId) {
            this.hitId = hitId;
        }

        public final Collection<String> getPolicyLevels() {
            return this.policyLevels;
        }

        @Override
        public final Builder policyLevelsWithStrings(Collection<String> policyLevels) {
            this.policyLevels = ReviewPolicyLevelListCopier.copy(policyLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyLevelsWithStrings(String ... policyLevels) {
            this.policyLevelsWithStrings(Arrays.asList(policyLevels));
            return this;
        }

        @Override
        public final Builder policyLevels(Collection<ReviewPolicyLevel> policyLevels) {
            this.policyLevels = ReviewPolicyLevelListCopier.copyEnumToString(policyLevels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyLevels(ReviewPolicyLevel ... policyLevels) {
            this.policyLevels(Arrays.asList(policyLevels));
            return this;
        }

        public final void setPolicyLevels(Collection<String> policyLevels) {
            this.policyLevels = ReviewPolicyLevelListCopier.copy(policyLevels);
        }

        public final Boolean getRetrieveActions() {
            return this.retrieveActions;
        }

        @Override
        public final Builder retrieveActions(Boolean retrieveActions) {
            this.retrieveActions = retrieveActions;
            return this;
        }

        public final void setRetrieveActions(Boolean retrieveActions) {
            this.retrieveActions = retrieveActions;
        }

        public final Boolean getRetrieveResults() {
            return this.retrieveResults;
        }

        @Override
        public final Builder retrieveResults(Boolean retrieveResults) {
            this.retrieveResults = retrieveResults;
            return this;
        }

        public final void setRetrieveResults(Boolean retrieveResults) {
            this.retrieveResults = retrieveResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListReviewPolicyResultsForHitRequest build() {
            return new ListReviewPolicyResultsForHitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MTurkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReviewPolicyResultsForHitRequest> {
        public Builder hitId(String var1);

        public Builder policyLevelsWithStrings(Collection<String> var1);

        public Builder policyLevelsWithStrings(String ... var1);

        public Builder policyLevels(Collection<ReviewPolicyLevel> var1);

        public Builder policyLevels(ReviewPolicyLevel ... var1);

        public Builder retrieveActions(Boolean var1);

        public Builder retrieveResults(Boolean var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

