/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthenticationStrategy {
    SIMPLE("SIMPLE"),
    LDAP("LDAP"),
    CONFIG_MANAGED("CONFIG_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthenticationStrategy> VALUE_MAP;
    private final String value;

    private AuthenticationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthenticationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthenticationStrategy> knownValues() {
        EnumSet<AuthenticationStrategy> knownValues = EnumSet.allOf(AuthenticationStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthenticationStrategy.class, AuthenticationStrategy::toString);
    }
}

