/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a list of all broker users. Does not apply to RabbitMQ brokers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserSummary implements SdkPojo, Serializable, ToCopyableBuilder<UserSummary.Builder, UserSummary> {
    private static final SdkField<String> PENDING_CHANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PendingChange").getter(getter(UserSummary::pendingChangeAsString))
            .setter(setter(Builder::pendingChange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingChange").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(UserSummary::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_CHANGE_FIELD,
            USERNAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String pendingChange;

    private final String username;

    private UserSummary(BuilderImpl builder) {
        this.pendingChange = builder.pendingChange;
        this.username = builder.username;
    }

    /**
     * <p>
     * The type of change pending for the broker user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pendingChange}
     * will return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pendingChangeAsString}.
     * </p>
     * 
     * @return The type of change pending for the broker user.
     * @see ChangeType
     */
    public final ChangeType pendingChange() {
        return ChangeType.fromValue(pendingChange);
    }

    /**
     * <p>
     * The type of change pending for the broker user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pendingChange}
     * will return {@link ChangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pendingChangeAsString}.
     * </p>
     * 
     * @return The type of change pending for the broker user.
     * @see ChangeType
     */
    public final String pendingChangeAsString() {
        return pendingChange;
    }

    /**
     * <p>
     * Required. The username of the broker user. This value can contain only alphanumeric characters, dashes, periods,
     * underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     * </p>
     * 
     * @return Required. The username of the broker user. This value can contain only alphanumeric characters, dashes,
     *         periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pendingChangeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSummary)) {
            return false;
        }
        UserSummary other = (UserSummary) obj;
        return Objects.equals(pendingChangeAsString(), other.pendingChangeAsString())
                && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserSummary").add("PendingChange", pendingChangeAsString()).add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PendingChange":
            return Optional.ofNullable(clazz.cast(pendingChangeAsString()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pendingChange", PENDING_CHANGE_FIELD);
        map.put("username", USERNAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserSummary, T> g) {
        return obj -> g.apply((UserSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserSummary> {
        /**
         * <p>
         * The type of change pending for the broker user.
         * </p>
         * 
         * @param pendingChange
         *        The type of change pending for the broker user.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder pendingChange(String pendingChange);

        /**
         * <p>
         * The type of change pending for the broker user.
         * </p>
         * 
         * @param pendingChange
         *        The type of change pending for the broker user.
         * @see ChangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeType
         */
        Builder pendingChange(ChangeType pendingChange);

        /**
         * <p>
         * Required. The username of the broker user. This value can contain only alphanumeric characters, dashes,
         * periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * </p>
         * 
         * @param username
         *        Required. The username of the broker user. This value can contain only alphanumeric characters,
         *        dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private String pendingChange;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSummary model) {
            pendingChange(model.pendingChange);
            username(model.username);
        }

        public final String getPendingChange() {
            return pendingChange;
        }

        public final void setPendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
        }

        @Override
        public final Builder pendingChange(String pendingChange) {
            this.pendingChange = pendingChange;
            return this;
        }

        @Override
        public final Builder pendingChange(ChangeType pendingChange) {
            this.pendingChange(pendingChange == null ? null : pendingChange.toString());
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public UserSummary build() {
            return new UserSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
