/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Action required for a broker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionRequired implements SdkPojo, Serializable, ToCopyableBuilder<ActionRequired.Builder, ActionRequired> {
    private static final SdkField<String> ACTION_REQUIRED_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionRequiredCode").getter(getter(ActionRequired::actionRequiredCode))
            .setter(setter(Builder::actionRequiredCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionRequiredCode").build())
            .build();

    private static final SdkField<String> ACTION_REQUIRED_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionRequiredInfo").getter(getter(ActionRequired::actionRequiredInfo))
            .setter(setter(Builder::actionRequiredInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionRequiredInfo").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_REQUIRED_CODE_FIELD,
            ACTION_REQUIRED_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String actionRequiredCode;

    private final String actionRequiredInfo;

    private ActionRequired(BuilderImpl builder) {
        this.actionRequiredCode = builder.actionRequiredCode;
        this.actionRequiredInfo = builder.actionRequiredInfo;
    }

    /**
     * <p>
     * The code you can use to find instructions on the action required to resolve your broker issue.
     * </p>
     * 
     * @return The code you can use to find instructions on the action required to resolve your broker issue.
     */
    public final String actionRequiredCode() {
        return actionRequiredCode;
    }

    /**
     * <p>
     * Information about the action required to resolve your broker issue.
     * </p>
     * 
     * @return Information about the action required to resolve your broker issue.
     */
    public final String actionRequiredInfo() {
        return actionRequiredInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionRequiredCode());
        hashCode = 31 * hashCode + Objects.hashCode(actionRequiredInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionRequired)) {
            return false;
        }
        ActionRequired other = (ActionRequired) obj;
        return Objects.equals(actionRequiredCode(), other.actionRequiredCode())
                && Objects.equals(actionRequiredInfo(), other.actionRequiredInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionRequired").add("ActionRequiredCode", actionRequiredCode())
                .add("ActionRequiredInfo", actionRequiredInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionRequiredCode":
            return Optional.ofNullable(clazz.cast(actionRequiredCode()));
        case "ActionRequiredInfo":
            return Optional.ofNullable(clazz.cast(actionRequiredInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionRequired, T> g) {
        return obj -> g.apply((ActionRequired) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionRequired> {
        /**
         * <p>
         * The code you can use to find instructions on the action required to resolve your broker issue.
         * </p>
         * 
         * @param actionRequiredCode
         *        The code you can use to find instructions on the action required to resolve your broker issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionRequiredCode(String actionRequiredCode);

        /**
         * <p>
         * Information about the action required to resolve your broker issue.
         * </p>
         * 
         * @param actionRequiredInfo
         *        Information about the action required to resolve your broker issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionRequiredInfo(String actionRequiredInfo);
    }

    static final class BuilderImpl implements Builder {
        private String actionRequiredCode;

        private String actionRequiredInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionRequired model) {
            actionRequiredCode(model.actionRequiredCode);
            actionRequiredInfo(model.actionRequiredInfo);
        }

        public final String getActionRequiredCode() {
            return actionRequiredCode;
        }

        public final void setActionRequiredCode(String actionRequiredCode) {
            this.actionRequiredCode = actionRequiredCode;
        }

        @Override
        public final Builder actionRequiredCode(String actionRequiredCode) {
            this.actionRequiredCode = actionRequiredCode;
            return this;
        }

        public final String getActionRequiredInfo() {
            return actionRequiredInfo;
        }

        public final void setActionRequiredInfo(String actionRequiredInfo) {
            this.actionRequiredInfo = actionRequiredInfo;
        }

        @Override
        public final Builder actionRequiredInfo(String actionRequiredInfo) {
            this.actionRequiredInfo = actionRequiredInfo;
            return this;
        }

        @Override
        public ActionRequired build() {
            return new ActionRequired(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
