/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mq.MqClient;
import software.amazon.awssdk.services.mq.model.BrokerSummary;
import software.amazon.awssdk.services.mq.model.ListBrokersRequest;
import software.amazon.awssdk.services.mq.model.ListBrokersResponse;

public class ListBrokersIterable
implements SdkIterable<ListBrokersResponse> {
    private final MqClient client;
    private final ListBrokersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBrokersIterable(MqClient client, ListBrokersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBrokersResponseFetcher();
    }

    public Iterator<ListBrokersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BrokerSummary> brokerSummaries() {
        Function<ListBrokersResponse, Iterator> getIterator = response -> {
            if (response != null && response.brokerSummaries() != null) {
                return response.brokerSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBrokersResponseFetcher
    implements SyncPageFetcher<ListBrokersResponse> {
        private ListBrokersResponseFetcher() {
        }

        public boolean hasNextPage(ListBrokersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBrokersResponse nextPage(ListBrokersResponse previousPage) {
            if (previousPage == null) {
                return ListBrokersIterable.this.client.listBrokers(ListBrokersIterable.this.firstRequest);
            }
            return ListBrokersIterable.this.client.listBrokers((ListBrokersRequest)((Object)ListBrokersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

