/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mq.model.AuthenticationStrategy;
import software.amazon.awssdk.services.mq.model.BrokerInstance;
import software.amazon.awssdk.services.mq.model.BrokerState;
import software.amazon.awssdk.services.mq.model.BrokerStorageType;
import software.amazon.awssdk.services.mq.model.Configurations;
import software.amazon.awssdk.services.mq.model.DeploymentMode;
import software.amazon.awssdk.services.mq.model.EncryptionOptions;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.LdapServerMetadataOutput;
import software.amazon.awssdk.services.mq.model.LogsSummary;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.services.mq.model.UserSummary;
import software.amazon.awssdk.services.mq.model.WeeklyStartTime;
import software.amazon.awssdk.services.mq.model.___listOfBrokerInstanceCopier;
import software.amazon.awssdk.services.mq.model.___listOfUserSummaryCopier;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.services.mq.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBrokerResponse
extends MqResponse
implements ToCopyableBuilder<Builder, DescribeBrokerResponse> {
    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationStrategy").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::authenticationStrategyAsString)).setter(DescribeBrokerResponse.setter(Builder::authenticationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationStrategy").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::autoMinorVersionUpgrade)).setter(DescribeBrokerResponse.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> BROKER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerArn").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerArn)).setter(DescribeBrokerResponse.setter(Builder::brokerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerArn").build()}).build();
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerId").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerId)).setter(DescribeBrokerResponse.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()}).build();
    private static final SdkField<List<BrokerInstance>> BROKER_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BrokerInstances").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerInstances)).setter(DescribeBrokerResponse.setter(Builder::brokerInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrokerInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BROKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerName").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerName)).setter(DescribeBrokerResponse.setter(Builder::brokerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerName").build()}).build();
    private static final SdkField<String> BROKER_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerState").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::brokerStateAsString)).setter(DescribeBrokerResponse.setter(Builder::brokerState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerState").build()}).build();
    private static final SdkField<Configurations> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configurations").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::configurations)).setter(DescribeBrokerResponse.setter(Builder::configurations)).constructor(Configurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::created)).setter(DescribeBrokerResponse.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentMode").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::deploymentModeAsString)).setter(DescribeBrokerResponse.setter(Builder::deploymentMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()}).build();
    private static final SdkField<EncryptionOptions> ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionOptions").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::encryptionOptions)).setter(DescribeBrokerResponse.setter(Builder::encryptionOptions)).constructor(EncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionOptions").build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineType").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::engineTypeAsString)).setter(DescribeBrokerResponse.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::engineVersion)).setter(DescribeBrokerResponse.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostInstanceType").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::hostInstanceType)).setter(DescribeBrokerResponse.setter(Builder::hostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()}).build();
    private static final SdkField<LdapServerMetadataOutput> LDAP_SERVER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LdapServerMetadata").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::ldapServerMetadata)).setter(DescribeBrokerResponse.setter(Builder::ldapServerMetadata)).constructor(LdapServerMetadataOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ldapServerMetadata").build()}).build();
    private static final SdkField<LogsSummary> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Logs").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::logs)).setter(DescribeBrokerResponse.setter(Builder::logs)).constructor(LogsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final SdkField<WeeklyStartTime> MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceWindowStartTime").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::maintenanceWindowStartTime)).setter(DescribeBrokerResponse.setter(Builder::maintenanceWindowStartTime)).constructor(WeeklyStartTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindowStartTime").build()}).build();
    private static final SdkField<String> PENDING_AUTHENTICATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PendingAuthenticationStrategy").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::pendingAuthenticationStrategyAsString)).setter(DescribeBrokerResponse.setter(Builder::pendingAuthenticationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingAuthenticationStrategy").build()}).build();
    private static final SdkField<String> PENDING_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PendingEngineVersion").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::pendingEngineVersion)).setter(DescribeBrokerResponse.setter(Builder::pendingEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingEngineVersion").build()}).build();
    private static final SdkField<String> PENDING_HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PendingHostInstanceType").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::pendingHostInstanceType)).setter(DescribeBrokerResponse.setter(Builder::pendingHostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingHostInstanceType").build()}).build();
    private static final SdkField<LdapServerMetadataOutput> PENDING_LDAP_SERVER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingLdapServerMetadata").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::pendingLdapServerMetadata)).setter(DescribeBrokerResponse.setter(Builder::pendingLdapServerMetadata)).constructor(LdapServerMetadataOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingLdapServerMetadata").build()}).build();
    private static final SdkField<List<String>> PENDING_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PendingSecurityGroups").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::pendingSecurityGroups)).setter(DescribeBrokerResponse.setter(Builder::pendingSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::publiclyAccessible)).setter(DescribeBrokerResponse.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::securityGroups)).setter(DescribeBrokerResponse.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::storageTypeAsString)).setter(DescribeBrokerResponse.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::subnetIds)).setter(DescribeBrokerResponse.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::tags)).setter(DescribeBrokerResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<UserSummary>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Users").getter(DescribeBrokerResponse.getter(DescribeBrokerResponse::users)).setter(DescribeBrokerResponse.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_STRATEGY_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ARN_FIELD, BROKER_ID_FIELD, BROKER_INSTANCES_FIELD, BROKER_NAME_FIELD, BROKER_STATE_FIELD, CONFIGURATIONS_FIELD, CREATED_FIELD, DEPLOYMENT_MODE_FIELD, ENCRYPTION_OPTIONS_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, HOST_INSTANCE_TYPE_FIELD, LDAP_SERVER_METADATA_FIELD, LOGS_FIELD, MAINTENANCE_WINDOW_START_TIME_FIELD, PENDING_AUTHENTICATION_STRATEGY_FIELD, PENDING_ENGINE_VERSION_FIELD, PENDING_HOST_INSTANCE_TYPE_FIELD, PENDING_LDAP_SERVER_METADATA_FIELD, PENDING_SECURITY_GROUPS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUPS_FIELD, STORAGE_TYPE_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, USERS_FIELD));
    private final String authenticationStrategy;
    private final Boolean autoMinorVersionUpgrade;
    private final String brokerArn;
    private final String brokerId;
    private final List<BrokerInstance> brokerInstances;
    private final String brokerName;
    private final String brokerState;
    private final Configurations configurations;
    private final Instant created;
    private final String deploymentMode;
    private final EncryptionOptions encryptionOptions;
    private final String engineType;
    private final String engineVersion;
    private final String hostInstanceType;
    private final LdapServerMetadataOutput ldapServerMetadata;
    private final LogsSummary logs;
    private final WeeklyStartTime maintenanceWindowStartTime;
    private final String pendingAuthenticationStrategy;
    private final String pendingEngineVersion;
    private final String pendingHostInstanceType;
    private final LdapServerMetadataOutput pendingLdapServerMetadata;
    private final List<String> pendingSecurityGroups;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroups;
    private final String storageType;
    private final List<String> subnetIds;
    private final Map<String, String> tags;
    private final List<UserSummary> users;

    private DescribeBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationStrategy = builder.authenticationStrategy;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerArn = builder.brokerArn;
        this.brokerId = builder.brokerId;
        this.brokerInstances = builder.brokerInstances;
        this.brokerName = builder.brokerName;
        this.brokerState = builder.brokerState;
        this.configurations = builder.configurations;
        this.created = builder.created;
        this.deploymentMode = builder.deploymentMode;
        this.encryptionOptions = builder.encryptionOptions;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.ldapServerMetadata = builder.ldapServerMetadata;
        this.logs = builder.logs;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.pendingAuthenticationStrategy = builder.pendingAuthenticationStrategy;
        this.pendingEngineVersion = builder.pendingEngineVersion;
        this.pendingHostInstanceType = builder.pendingHostInstanceType;
        this.pendingLdapServerMetadata = builder.pendingLdapServerMetadata;
        this.pendingSecurityGroups = builder.pendingSecurityGroups;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroups = builder.securityGroups;
        this.storageType = builder.storageType;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.users = builder.users;
    }

    public final AuthenticationStrategy authenticationStrategy() {
        return AuthenticationStrategy.fromValue(this.authenticationStrategy);
    }

    public final String authenticationStrategyAsString() {
        return this.authenticationStrategy;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final String brokerArn() {
        return this.brokerArn;
    }

    public final String brokerId() {
        return this.brokerId;
    }

    public final boolean hasBrokerInstances() {
        return this.brokerInstances != null && !(this.brokerInstances instanceof SdkAutoConstructList);
    }

    public final List<BrokerInstance> brokerInstances() {
        return this.brokerInstances;
    }

    public final String brokerName() {
        return this.brokerName;
    }

    public final BrokerState brokerState() {
        return BrokerState.fromValue(this.brokerState);
    }

    public final String brokerStateAsString() {
        return this.brokerState;
    }

    public final Configurations configurations() {
        return this.configurations;
    }

    public final Instant created() {
        return this.created;
    }

    public final DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(this.deploymentMode);
    }

    public final String deploymentModeAsString() {
        return this.deploymentMode;
    }

    public final EncryptionOptions encryptionOptions() {
        return this.encryptionOptions;
    }

    public final EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String hostInstanceType() {
        return this.hostInstanceType;
    }

    public final LdapServerMetadataOutput ldapServerMetadata() {
        return this.ldapServerMetadata;
    }

    public final LogsSummary logs() {
        return this.logs;
    }

    public final WeeklyStartTime maintenanceWindowStartTime() {
        return this.maintenanceWindowStartTime;
    }

    public final AuthenticationStrategy pendingAuthenticationStrategy() {
        return AuthenticationStrategy.fromValue(this.pendingAuthenticationStrategy);
    }

    public final String pendingAuthenticationStrategyAsString() {
        return this.pendingAuthenticationStrategy;
    }

    public final String pendingEngineVersion() {
        return this.pendingEngineVersion;
    }

    public final String pendingHostInstanceType() {
        return this.pendingHostInstanceType;
    }

    public final LdapServerMetadataOutput pendingLdapServerMetadata() {
        return this.pendingLdapServerMetadata;
    }

    public final boolean hasPendingSecurityGroups() {
        return this.pendingSecurityGroups != null && !(this.pendingSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> pendingSecurityGroups() {
        return this.pendingSecurityGroups;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final BrokerStorageType storageType() {
        return BrokerStorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<UserSummary> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBrokerInstances() ? this.brokerInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.ldapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingAuthenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingHostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingLdapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingSecurityGroups() ? this.pendingSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBrokerResponse)) {
            return false;
        }
        DescribeBrokerResponse other = (DescribeBrokerResponse)((Object)obj);
        return Objects.equals(this.authenticationStrategyAsString(), other.authenticationStrategyAsString()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.brokerArn(), other.brokerArn()) && Objects.equals(this.brokerId(), other.brokerId()) && this.hasBrokerInstances() == other.hasBrokerInstances() && Objects.equals(this.brokerInstances(), other.brokerInstances()) && Objects.equals(this.brokerName(), other.brokerName()) && Objects.equals(this.brokerStateAsString(), other.brokerStateAsString()) && Objects.equals(this.configurations(), other.configurations()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.deploymentModeAsString(), other.deploymentModeAsString()) && Objects.equals(this.encryptionOptions(), other.encryptionOptions()) && Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.ldapServerMetadata(), other.ldapServerMetadata()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.maintenanceWindowStartTime(), other.maintenanceWindowStartTime()) && Objects.equals(this.pendingAuthenticationStrategyAsString(), other.pendingAuthenticationStrategyAsString()) && Objects.equals(this.pendingEngineVersion(), other.pendingEngineVersion()) && Objects.equals(this.pendingHostInstanceType(), other.pendingHostInstanceType()) && Objects.equals(this.pendingLdapServerMetadata(), other.pendingLdapServerMetadata()) && this.hasPendingSecurityGroups() == other.hasPendingSecurityGroups() && Objects.equals(this.pendingSecurityGroups(), other.pendingSecurityGroups()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBrokerResponse").add("AuthenticationStrategy", (Object)this.authenticationStrategyAsString()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("BrokerArn", (Object)this.brokerArn()).add("BrokerId", (Object)this.brokerId()).add("BrokerInstances", this.hasBrokerInstances() ? this.brokerInstances() : null).add("BrokerName", (Object)this.brokerName()).add("BrokerState", (Object)this.brokerStateAsString()).add("Configurations", (Object)this.configurations()).add("Created", (Object)this.created()).add("DeploymentMode", (Object)this.deploymentModeAsString()).add("EncryptionOptions", (Object)this.encryptionOptions()).add("EngineType", (Object)this.engineTypeAsString()).add("EngineVersion", (Object)this.engineVersion()).add("HostInstanceType", (Object)this.hostInstanceType()).add("LdapServerMetadata", (Object)this.ldapServerMetadata()).add("Logs", (Object)this.logs()).add("MaintenanceWindowStartTime", (Object)this.maintenanceWindowStartTime()).add("PendingAuthenticationStrategy", (Object)this.pendingAuthenticationStrategyAsString()).add("PendingEngineVersion", (Object)this.pendingEngineVersion()).add("PendingHostInstanceType", (Object)this.pendingHostInstanceType()).add("PendingLdapServerMetadata", (Object)this.pendingLdapServerMetadata()).add("PendingSecurityGroups", this.hasPendingSecurityGroups() ? this.pendingSecurityGroups() : null).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("StorageType", (Object)this.storageTypeAsString()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("Users", this.hasUsers() ? this.users() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationStrategy": {
                return Optional.ofNullable(clazz.cast(this.authenticationStrategyAsString()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "BrokerArn": {
                return Optional.ofNullable(clazz.cast(this.brokerArn()));
            }
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "BrokerInstances": {
                return Optional.ofNullable(clazz.cast(this.brokerInstances()));
            }
            case "BrokerName": {
                return Optional.ofNullable(clazz.cast(this.brokerName()));
            }
            case "BrokerState": {
                return Optional.ofNullable(clazz.cast(this.brokerStateAsString()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "DeploymentMode": {
                return Optional.ofNullable(clazz.cast(this.deploymentModeAsString()));
            }
            case "EncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionOptions()));
            }
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "HostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.hostInstanceType()));
            }
            case "LdapServerMetadata": {
                return Optional.ofNullable(clazz.cast(this.ldapServerMetadata()));
            }
            case "Logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "MaintenanceWindowStartTime": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindowStartTime()));
            }
            case "PendingAuthenticationStrategy": {
                return Optional.ofNullable(clazz.cast(this.pendingAuthenticationStrategyAsString()));
            }
            case "PendingEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.pendingEngineVersion()));
            }
            case "PendingHostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.pendingHostInstanceType()));
            }
            case "PendingLdapServerMetadata": {
                return Optional.ofNullable(clazz.cast(this.pendingLdapServerMetadata()));
            }
            case "PendingSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.pendingSecurityGroups()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBrokerResponse, T> g) {
        return obj -> g.apply((DescribeBrokerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private String authenticationStrategy;
        private Boolean autoMinorVersionUpgrade;
        private String brokerArn;
        private String brokerId;
        private List<BrokerInstance> brokerInstances = DefaultSdkAutoConstructList.getInstance();
        private String brokerName;
        private String brokerState;
        private Configurations configurations;
        private Instant created;
        private String deploymentMode;
        private EncryptionOptions encryptionOptions;
        private String engineType;
        private String engineVersion;
        private String hostInstanceType;
        private LdapServerMetadataOutput ldapServerMetadata;
        private LogsSummary logs;
        private WeeklyStartTime maintenanceWindowStartTime;
        private String pendingAuthenticationStrategy;
        private String pendingEngineVersion;
        private String pendingHostInstanceType;
        private LdapServerMetadataOutput pendingLdapServerMetadata;
        private List<String> pendingSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private Boolean publiclyAccessible;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String storageType;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<UserSummary> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBrokerResponse model) {
            super(model);
            this.authenticationStrategy(model.authenticationStrategy);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.brokerArn(model.brokerArn);
            this.brokerId(model.brokerId);
            this.brokerInstances(model.brokerInstances);
            this.brokerName(model.brokerName);
            this.brokerState(model.brokerState);
            this.configurations(model.configurations);
            this.created(model.created);
            this.deploymentMode(model.deploymentMode);
            this.encryptionOptions(model.encryptionOptions);
            this.engineType(model.engineType);
            this.engineVersion(model.engineVersion);
            this.hostInstanceType(model.hostInstanceType);
            this.ldapServerMetadata(model.ldapServerMetadata);
            this.logs(model.logs);
            this.maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            this.pendingAuthenticationStrategy(model.pendingAuthenticationStrategy);
            this.pendingEngineVersion(model.pendingEngineVersion);
            this.pendingHostInstanceType(model.pendingHostInstanceType);
            this.pendingLdapServerMetadata(model.pendingLdapServerMetadata);
            this.pendingSecurityGroups(model.pendingSecurityGroups);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroups(model.securityGroups);
            this.storageType(model.storageType);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
            this.users(model.users);
        }

        public final String getAuthenticationStrategy() {
            return this.authenticationStrategy;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        @Override
        @Transient
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy(authenticationStrategy == null ? null : authenticationStrategy.toString());
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        @Transient
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getBrokerArn() {
            return this.brokerArn;
        }

        public final void setBrokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
        }

        @Override
        @Transient
        public final Builder brokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        @Override
        @Transient
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final List<BrokerInstance.Builder> getBrokerInstances() {
            List<BrokerInstance.Builder> result = ___listOfBrokerInstanceCopier.copyToBuilder(this.brokerInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBrokerInstances(Collection<BrokerInstance.BuilderImpl> brokerInstances) {
            this.brokerInstances = ___listOfBrokerInstanceCopier.copyFromBuilder(brokerInstances);
        }

        @Override
        @Transient
        public final Builder brokerInstances(Collection<BrokerInstance> brokerInstances) {
            this.brokerInstances = ___listOfBrokerInstanceCopier.copy(brokerInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder brokerInstances(BrokerInstance ... brokerInstances) {
            this.brokerInstances(Arrays.asList(brokerInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder brokerInstances(Consumer<BrokerInstance.Builder> ... brokerInstances) {
            this.brokerInstances(Stream.of(brokerInstances).map(c -> (BrokerInstance)((BrokerInstance.Builder)BrokerInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBrokerName() {
            return this.brokerName;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        @Override
        @Transient
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final String getBrokerState() {
            return this.brokerState;
        }

        public final void setBrokerState(String brokerState) {
            this.brokerState = brokerState;
        }

        @Override
        @Transient
        public final Builder brokerState(String brokerState) {
            this.brokerState = brokerState;
            return this;
        }

        @Override
        @Transient
        public final Builder brokerState(BrokerState brokerState) {
            this.brokerState(brokerState == null ? null : brokerState.toString());
            return this;
        }

        public final Configurations.Builder getConfigurations() {
            return this.configurations != null ? this.configurations.toBuilder() : null;
        }

        public final void setConfigurations(Configurations.BuilderImpl configurations) {
            this.configurations = configurations != null ? configurations.build() : null;
        }

        @Override
        @Transient
        public final Builder configurations(Configurations configurations) {
            this.configurations = configurations;
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        @Transient
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getDeploymentMode() {
            return this.deploymentMode;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        @Override
        @Transient
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        @Transient
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        public final EncryptionOptions.Builder getEncryptionOptions() {
            return this.encryptionOptions != null ? this.encryptionOptions.toBuilder() : null;
        }

        public final void setEncryptionOptions(EncryptionOptions.BuilderImpl encryptionOptions) {
            this.encryptionOptions = encryptionOptions != null ? encryptionOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionOptions(EncryptionOptions encryptionOptions) {
            this.encryptionOptions = encryptionOptions;
            return this;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        @Transient
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        @Transient
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        @Transient
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final LdapServerMetadataOutput.Builder getLdapServerMetadata() {
            return this.ldapServerMetadata != null ? this.ldapServerMetadata.toBuilder() : null;
        }

        public final void setLdapServerMetadata(LdapServerMetadataOutput.BuilderImpl ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata != null ? ldapServerMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder ldapServerMetadata(LdapServerMetadataOutput ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        public final LogsSummary.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        public final void setLogs(LogsSummary.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        @Transient
        public final Builder logs(LogsSummary logs) {
            this.logs = logs;
            return this;
        }

        public final WeeklyStartTime.Builder getMaintenanceWindowStartTime() {
            return this.maintenanceWindowStartTime != null ? this.maintenanceWindowStartTime.toBuilder() : null;
        }

        public final void setMaintenanceWindowStartTime(WeeklyStartTime.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        @Override
        @Transient
        public final Builder maintenanceWindowStartTime(WeeklyStartTime maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final String getPendingAuthenticationStrategy() {
            return this.pendingAuthenticationStrategy;
        }

        public final void setPendingAuthenticationStrategy(String pendingAuthenticationStrategy) {
            this.pendingAuthenticationStrategy = pendingAuthenticationStrategy;
        }

        @Override
        @Transient
        public final Builder pendingAuthenticationStrategy(String pendingAuthenticationStrategy) {
            this.pendingAuthenticationStrategy = pendingAuthenticationStrategy;
            return this;
        }

        @Override
        @Transient
        public final Builder pendingAuthenticationStrategy(AuthenticationStrategy pendingAuthenticationStrategy) {
            this.pendingAuthenticationStrategy(pendingAuthenticationStrategy == null ? null : pendingAuthenticationStrategy.toString());
            return this;
        }

        public final String getPendingEngineVersion() {
            return this.pendingEngineVersion;
        }

        public final void setPendingEngineVersion(String pendingEngineVersion) {
            this.pendingEngineVersion = pendingEngineVersion;
        }

        @Override
        @Transient
        public final Builder pendingEngineVersion(String pendingEngineVersion) {
            this.pendingEngineVersion = pendingEngineVersion;
            return this;
        }

        public final String getPendingHostInstanceType() {
            return this.pendingHostInstanceType;
        }

        public final void setPendingHostInstanceType(String pendingHostInstanceType) {
            this.pendingHostInstanceType = pendingHostInstanceType;
        }

        @Override
        @Transient
        public final Builder pendingHostInstanceType(String pendingHostInstanceType) {
            this.pendingHostInstanceType = pendingHostInstanceType;
            return this;
        }

        public final LdapServerMetadataOutput.Builder getPendingLdapServerMetadata() {
            return this.pendingLdapServerMetadata != null ? this.pendingLdapServerMetadata.toBuilder() : null;
        }

        public final void setPendingLdapServerMetadata(LdapServerMetadataOutput.BuilderImpl pendingLdapServerMetadata) {
            this.pendingLdapServerMetadata = pendingLdapServerMetadata != null ? pendingLdapServerMetadata.build() : null;
        }

        @Override
        @Transient
        public final Builder pendingLdapServerMetadata(LdapServerMetadataOutput pendingLdapServerMetadata) {
            this.pendingLdapServerMetadata = pendingLdapServerMetadata;
            return this;
        }

        public final Collection<String> getPendingSecurityGroups() {
            if (this.pendingSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pendingSecurityGroups;
        }

        public final void setPendingSecurityGroups(Collection<String> pendingSecurityGroups) {
            this.pendingSecurityGroups = ___listOf__stringCopier.copy(pendingSecurityGroups);
        }

        @Override
        @Transient
        public final Builder pendingSecurityGroups(Collection<String> pendingSecurityGroups) {
            this.pendingSecurityGroups = ___listOf__stringCopier.copy(pendingSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pendingSecurityGroups(String ... pendingSecurityGroups) {
            this.pendingSecurityGroups(Arrays.asList(pendingSecurityGroups));
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        @Transient
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        @Transient
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        @Transient
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        @Transient
        public final Builder storageType(BrokerStorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
        }

        @Override
        @Transient
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = ___listOf__stringCopier.copy(subnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final List<UserSummary.Builder> getUsers() {
            List<UserSummary.Builder> result = ___listOfUserSummaryCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<UserSummary.BuilderImpl> users) {
            this.users = ___listOfUserSummaryCopier.copyFromBuilder(users);
        }

        @Override
        @Transient
        public final Builder users(Collection<UserSummary> users) {
            this.users = ___listOfUserSummaryCopier.copy(users);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder users(UserSummary ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder users(Consumer<UserSummary.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (UserSummary)((UserSummary.Builder)UserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeBrokerResponse build() {
            return new DescribeBrokerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBrokerResponse> {
        public Builder authenticationStrategy(String var1);

        public Builder authenticationStrategy(AuthenticationStrategy var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder brokerArn(String var1);

        public Builder brokerId(String var1);

        public Builder brokerInstances(Collection<BrokerInstance> var1);

        public Builder brokerInstances(BrokerInstance ... var1);

        public Builder brokerInstances(Consumer<BrokerInstance.Builder> ... var1);

        public Builder brokerName(String var1);

        public Builder brokerState(String var1);

        public Builder brokerState(BrokerState var1);

        public Builder configurations(Configurations var1);

        default public Builder configurations(Consumer<Configurations.Builder> configurations) {
            return this.configurations((Configurations)((Configurations.Builder)Configurations.builder().applyMutation(configurations)).build());
        }

        public Builder created(Instant var1);

        public Builder deploymentMode(String var1);

        public Builder deploymentMode(DeploymentMode var1);

        public Builder encryptionOptions(EncryptionOptions var1);

        default public Builder encryptionOptions(Consumer<EncryptionOptions.Builder> encryptionOptions) {
            return this.encryptionOptions((EncryptionOptions)((EncryptionOptions.Builder)EncryptionOptions.builder().applyMutation(encryptionOptions)).build());
        }

        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder engineVersion(String var1);

        public Builder hostInstanceType(String var1);

        public Builder ldapServerMetadata(LdapServerMetadataOutput var1);

        default public Builder ldapServerMetadata(Consumer<LdapServerMetadataOutput.Builder> ldapServerMetadata) {
            return this.ldapServerMetadata((LdapServerMetadataOutput)((LdapServerMetadataOutput.Builder)LdapServerMetadataOutput.builder().applyMutation(ldapServerMetadata)).build());
        }

        public Builder logs(LogsSummary var1);

        default public Builder logs(Consumer<LogsSummary.Builder> logs) {
            return this.logs((LogsSummary)((LogsSummary.Builder)LogsSummary.builder().applyMutation(logs)).build());
        }

        public Builder maintenanceWindowStartTime(WeeklyStartTime var1);

        default public Builder maintenanceWindowStartTime(Consumer<WeeklyStartTime.Builder> maintenanceWindowStartTime) {
            return this.maintenanceWindowStartTime((WeeklyStartTime)((WeeklyStartTime.Builder)WeeklyStartTime.builder().applyMutation(maintenanceWindowStartTime)).build());
        }

        public Builder pendingAuthenticationStrategy(String var1);

        public Builder pendingAuthenticationStrategy(AuthenticationStrategy var1);

        public Builder pendingEngineVersion(String var1);

        public Builder pendingHostInstanceType(String var1);

        public Builder pendingLdapServerMetadata(LdapServerMetadataOutput var1);

        default public Builder pendingLdapServerMetadata(Consumer<LdapServerMetadataOutput.Builder> pendingLdapServerMetadata) {
            return this.pendingLdapServerMetadata((LdapServerMetadataOutput)((LdapServerMetadataOutput.Builder)LdapServerMetadataOutput.builder().applyMutation(pendingLdapServerMetadata)).build());
        }

        public Builder pendingSecurityGroups(Collection<String> var1);

        public Builder pendingSecurityGroups(String ... var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder storageType(String var1);

        public Builder storageType(BrokerStorageType var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder users(Collection<UserSummary> var1);

        public Builder users(UserSummary ... var1);

        public Builder users(Consumer<UserSummary.Builder> ... var1);
    }
}

