/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.EngineType;
import software.amazon.awssdk.services.mq.model.EngineVersion;
import software.amazon.awssdk.services.mq.model.___listOfEngineVersionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerEngineType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerEngineType> {
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineType").getter(BrokerEngineType.getter(BrokerEngineType::engineTypeAsString)).setter(BrokerEngineType.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineType").build()}).build();
    private static final SdkField<List<EngineVersion>> ENGINE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngineVersions").getter(BrokerEngineType.getter(BrokerEngineType::engineVersions)).setter(BrokerEngineType.setter(Builder::engineVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_TYPE_FIELD, ENGINE_VERSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engineType;
    private final List<EngineVersion> engineVersions;

    private BrokerEngineType(BuilderImpl builder) {
        this.engineType = builder.engineType;
        this.engineVersions = builder.engineVersions;
    }

    public final EngineType engineType() {
        return EngineType.fromValue(this.engineType);
    }

    public final String engineTypeAsString() {
        return this.engineType;
    }

    public final boolean hasEngineVersions() {
        return this.engineVersions != null && !(this.engineVersions instanceof SdkAutoConstructList);
    }

    public final List<EngineVersion> engineVersions() {
        return this.engineVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngineVersions() ? this.engineVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerEngineType)) {
            return false;
        }
        BrokerEngineType other = (BrokerEngineType)obj;
        return Objects.equals(this.engineTypeAsString(), other.engineTypeAsString()) && this.hasEngineVersions() == other.hasEngineVersions() && Objects.equals(this.engineVersions(), other.engineVersions());
    }

    public final String toString() {
        return ToString.builder((String)"BrokerEngineType").add("EngineType", (Object)this.engineTypeAsString()).add("EngineVersions", this.hasEngineVersions() ? this.engineVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineTypeAsString()));
            }
            case "EngineVersions": {
                return Optional.ofNullable(clazz.cast(this.engineVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerEngineType, T> g) {
        return obj -> g.apply((BrokerEngineType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineType;
        private List<EngineVersion> engineVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerEngineType model) {
            this.engineType(model.engineType);
            this.engineVersions(model.engineVersions);
        }

        public final String getEngineType() {
            return this.engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        public final List<EngineVersion.Builder> getEngineVersions() {
            List<EngineVersion.Builder> result = ___listOfEngineVersionCopier.copyToBuilder(this.engineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder engineVersions(Collection<EngineVersion> engineVersions) {
            this.engineVersions = ___listOfEngineVersionCopier.copy(engineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(EngineVersion ... engineVersions) {
            this.engineVersions(Arrays.asList(engineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(Consumer<EngineVersion.Builder> ... engineVersions) {
            this.engineVersions(Stream.of(engineVersions).map(c -> (EngineVersion)((EngineVersion.Builder)EngineVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEngineVersions(Collection<EngineVersion.BuilderImpl> engineVersions) {
            this.engineVersions = ___listOfEngineVersionCopier.copyFromBuilder(engineVersions);
        }

        public BrokerEngineType build() {
            return new BrokerEngineType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerEngineType> {
        public Builder engineType(String var1);

        public Builder engineType(EngineType var1);

        public Builder engineVersions(Collection<EngineVersion> var1);

        public Builder engineVersions(EngineVersion ... var1);

        public Builder engineVersions(Consumer<EngineVersion.Builder> ... var1);
    }
}

