/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.AuthenticationStrategy;
import software.amazon.awssdk.services.mq.model.ConfigurationId;
import software.amazon.awssdk.services.mq.model.LdapServerMetadataOutput;
import software.amazon.awssdk.services.mq.model.Logs;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrokerResponse
extends MqResponse
implements ToCopyableBuilder<Builder, UpdateBrokerResponse> {
    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationStrategy").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::authenticationStrategyAsString)).setter(UpdateBrokerResponse.setter(Builder::authenticationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationStrategy").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::autoMinorVersionUpgrade)).setter(UpdateBrokerResponse.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerId").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::brokerId)).setter(UpdateBrokerResponse.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()}).build();
    private static final SdkField<ConfigurationId> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::configuration)).setter(UpdateBrokerResponse.setter(Builder::configuration)).constructor(ConfigurationId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::engineVersion)).setter(UpdateBrokerResponse.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()}).build();
    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostInstanceType").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::hostInstanceType)).setter(UpdateBrokerResponse.setter(Builder::hostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()}).build();
    private static final SdkField<LdapServerMetadataOutput> LDAP_SERVER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LdapServerMetadata").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::ldapServerMetadata)).setter(UpdateBrokerResponse.setter(Builder::ldapServerMetadata)).constructor(LdapServerMetadataOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ldapServerMetadata").build()}).build();
    private static final SdkField<Logs> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Logs").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::logs)).setter(UpdateBrokerResponse.setter(Builder::logs)).constructor(Logs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(UpdateBrokerResponse.getter(UpdateBrokerResponse::securityGroups)).setter(UpdateBrokerResponse.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_STRATEGY_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ID_FIELD, CONFIGURATION_FIELD, ENGINE_VERSION_FIELD, HOST_INSTANCE_TYPE_FIELD, LDAP_SERVER_METADATA_FIELD, LOGS_FIELD, SECURITY_GROUPS_FIELD));
    private final String authenticationStrategy;
    private final Boolean autoMinorVersionUpgrade;
    private final String brokerId;
    private final ConfigurationId configuration;
    private final String engineVersion;
    private final String hostInstanceType;
    private final LdapServerMetadataOutput ldapServerMetadata;
    private final Logs logs;
    private final List<String> securityGroups;

    private UpdateBrokerResponse(BuilderImpl builder) {
        super(builder);
        this.authenticationStrategy = builder.authenticationStrategy;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerId = builder.brokerId;
        this.configuration = builder.configuration;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.ldapServerMetadata = builder.ldapServerMetadata;
        this.logs = builder.logs;
        this.securityGroups = builder.securityGroups;
    }

    public AuthenticationStrategy authenticationStrategy() {
        return AuthenticationStrategy.fromValue(this.authenticationStrategy);
    }

    public String authenticationStrategyAsString() {
        return this.authenticationStrategy;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public ConfigurationId configuration() {
        return this.configuration;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String hostInstanceType() {
        return this.hostInstanceType;
    }

    public LdapServerMetadataOutput ldapServerMetadata() {
        return this.ldapServerMetadata;
    }

    public Logs logs() {
        return this.logs;
    }

    public boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.ldapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrokerResponse)) {
            return false;
        }
        UpdateBrokerResponse other = (UpdateBrokerResponse)((Object)obj);
        return Objects.equals(this.authenticationStrategyAsString(), other.authenticationStrategyAsString()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.ldapServerMetadata(), other.ldapServerMetadata()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.securityGroups(), other.securityGroups());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBrokerResponse").add("AuthenticationStrategy", (Object)this.authenticationStrategyAsString()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("BrokerId", (Object)this.brokerId()).add("Configuration", (Object)this.configuration()).add("EngineVersion", (Object)this.engineVersion()).add("HostInstanceType", (Object)this.hostInstanceType()).add("LdapServerMetadata", (Object)this.ldapServerMetadata()).add("Logs", (Object)this.logs()).add("SecurityGroups", this.securityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationStrategy": {
                return Optional.ofNullable(clazz.cast(this.authenticationStrategyAsString()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "HostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.hostInstanceType()));
            }
            case "LdapServerMetadata": {
                return Optional.ofNullable(clazz.cast(this.ldapServerMetadata()));
            }
            case "Logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrokerResponse, T> g) {
        return obj -> g.apply((UpdateBrokerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private String authenticationStrategy;
        private Boolean autoMinorVersionUpgrade;
        private String brokerId;
        private ConfigurationId configuration;
        private String engineVersion;
        private String hostInstanceType;
        private LdapServerMetadataOutput ldapServerMetadata;
        private Logs logs;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrokerResponse model) {
            super(model);
            this.authenticationStrategy(model.authenticationStrategy);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.brokerId(model.brokerId);
            this.configuration(model.configuration);
            this.engineVersion(model.engineVersion);
            this.hostInstanceType(model.hostInstanceType);
            this.ldapServerMetadata(model.ldapServerMetadata);
            this.logs(model.logs);
            this.securityGroups(model.securityGroups);
        }

        public final String getAuthenticationStrategy() {
            return this.authenticationStrategy;
        }

        @Override
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        @Override
        public final Builder authenticationStrategy(AuthenticationStrategy authenticationStrategy) {
            this.authenticationStrategy(authenticationStrategy == null ? null : authenticationStrategy.toString());
            return this;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final ConfigurationId.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ConfigurationId configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ConfigurationId.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        public final LdapServerMetadataOutput.Builder getLdapServerMetadata() {
            return this.ldapServerMetadata != null ? this.ldapServerMetadata.toBuilder() : null;
        }

        @Override
        public final Builder ldapServerMetadata(LdapServerMetadataOutput ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        public final void setLdapServerMetadata(LdapServerMetadataOutput.BuilderImpl ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata != null ? ldapServerMetadata.build() : null;
        }

        public final Logs.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(Logs logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(Logs.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        @Override
        public UpdateBrokerResponse build() {
            return new UpdateBrokerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrokerResponse> {
        public Builder authenticationStrategy(String var1);

        public Builder authenticationStrategy(AuthenticationStrategy var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder brokerId(String var1);

        public Builder configuration(ConfigurationId var1);

        default public Builder configuration(Consumer<ConfigurationId.Builder> configuration) {
            return this.configuration((ConfigurationId)((ConfigurationId.Builder)ConfigurationId.builder().applyMutation(configuration)).build());
        }

        public Builder engineVersion(String var1);

        public Builder hostInstanceType(String var1);

        public Builder ldapServerMetadata(LdapServerMetadataOutput var1);

        default public Builder ldapServerMetadata(Consumer<LdapServerMetadataOutput.Builder> ldapServerMetadata) {
            return this.ldapServerMetadata((LdapServerMetadataOutput)((LdapServerMetadataOutput.Builder)LdapServerMetadataOutput.builder().applyMutation(ldapServerMetadata)).build());
        }

        public Builder logs(Logs var1);

        default public Builder logs(Consumer<Logs.Builder> logs) {
            return this.logs((Logs)((Logs.Builder)Logs.builder().applyMutation(logs)).build());
        }

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);
    }
}

