/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.MqResponse;
import software.amazon.awssdk.services.mq.model.UserPendingChanges;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserResponse
extends MqResponse
implements ToCopyableBuilder<Builder, DescribeUserResponse> {
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerId").getter(DescribeUserResponse.getter(DescribeUserResponse::brokerId)).setter(DescribeUserResponse.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()}).build();
    private static final SdkField<Boolean> CONSOLE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ConsoleAccess").getter(DescribeUserResponse.getter(DescribeUserResponse::consoleAccess)).setter(DescribeUserResponse.setter(Builder::consoleAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleAccess").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(DescribeUserResponse.getter(DescribeUserResponse::groups)).setter(DescribeUserResponse.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<UserPendingChanges> PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Pending").getter(DescribeUserResponse.getter(DescribeUserResponse::pending)).setter(DescribeUserResponse.setter(Builder::pending)).constructor(UserPendingChanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(DescribeUserResponse.getter(DescribeUserResponse::username)).setter(DescribeUserResponse.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ID_FIELD, CONSOLE_ACCESS_FIELD, GROUPS_FIELD, PENDING_FIELD, USERNAME_FIELD));
    private final String brokerId;
    private final Boolean consoleAccess;
    private final List<String> groups;
    private final UserPendingChanges pending;
    private final String username;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.pending = builder.pending;
        this.username = builder.username;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public Boolean consoleAccess() {
        return this.consoleAccess;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<String> groups() {
        return this.groups;
    }

    public UserPendingChanges pending() {
        return this.pending;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse)((Object)obj);
        return Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.consoleAccess(), other.consoleAccess()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.pending(), other.pending()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserResponse").add("BrokerId", (Object)this.brokerId()).add("ConsoleAccess", (Object)this.consoleAccess()).add("Groups", this.groups()).add("Pending", (Object)this.pending()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "ConsoleAccess": {
                return Optional.ofNullable(clazz.cast(this.consoleAccess()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Pending": {
                return Optional.ofNullable(clazz.cast(this.pending()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MqResponse.BuilderImpl
    implements Builder {
        private String brokerId;
        private Boolean consoleAccess;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private UserPendingChanges pending;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            this.brokerId(model.brokerId);
            this.consoleAccess(model.consoleAccess);
            this.groups(model.groups);
            this.pending(model.pending);
            this.username(model.username);
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final Boolean getConsoleAccess() {
            return this.consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
        }

        public final UserPendingChanges.Builder getPending() {
            return this.pending != null ? this.pending.toBuilder() : null;
        }

        @Override
        public final Builder pending(UserPendingChanges pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(UserPendingChanges.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MqResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserResponse> {
        public Builder brokerId(String var1);

        public Builder consoleAccess(Boolean var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder pending(UserPendingChanges var1);

        default public Builder pending(Consumer<UserPendingChanges.Builder> pending) {
            return this.pending((UserPendingChanges)((UserPendingChanges.Builder)UserPendingChanges.builder().applyMutation(pending)).build());
        }

        public Builder username(String var1);
    }
}

