/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mq.model.BrokerState;
import software.amazon.awssdk.services.mq.model.DeploymentMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerSummary> {
    private static final SdkField<String> BROKER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerArn").getter(BrokerSummary.getter(BrokerSummary::brokerArn)).setter(BrokerSummary.setter(Builder::brokerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerArn").build()}).build();
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerId").getter(BrokerSummary.getter(BrokerSummary::brokerId)).setter(BrokerSummary.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()}).build();
    private static final SdkField<String> BROKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerName").getter(BrokerSummary.getter(BrokerSummary::brokerName)).setter(BrokerSummary.setter(Builder::brokerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerName").build()}).build();
    private static final SdkField<String> BROKER_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerState").getter(BrokerSummary.getter(BrokerSummary::brokerStateAsString)).setter(BrokerSummary.setter(Builder::brokerState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerState").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(BrokerSummary.getter(BrokerSummary::created)).setter(BrokerSummary.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentMode").getter(BrokerSummary.getter(BrokerSummary::deploymentModeAsString)).setter(BrokerSummary.setter(Builder::deploymentMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentMode").build()}).build();
    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostInstanceType").getter(BrokerSummary.getter(BrokerSummary::hostInstanceType)).setter(BrokerSummary.setter(Builder::hostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostInstanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ARN_FIELD, BROKER_ID_FIELD, BROKER_NAME_FIELD, BROKER_STATE_FIELD, CREATED_FIELD, DEPLOYMENT_MODE_FIELD, HOST_INSTANCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String brokerArn;
    private final String brokerId;
    private final String brokerName;
    private final String brokerState;
    private final Instant created;
    private final String deploymentMode;
    private final String hostInstanceType;

    private BrokerSummary(BuilderImpl builder) {
        this.brokerArn = builder.brokerArn;
        this.brokerId = builder.brokerId;
        this.brokerName = builder.brokerName;
        this.brokerState = builder.brokerState;
        this.created = builder.created;
        this.deploymentMode = builder.deploymentMode;
        this.hostInstanceType = builder.hostInstanceType;
    }

    public String brokerArn() {
        return this.brokerArn;
    }

    public String brokerId() {
        return this.brokerId;
    }

    public String brokerName() {
        return this.brokerName;
    }

    public BrokerState brokerState() {
        return BrokerState.fromValue(this.brokerState);
    }

    public String brokerStateAsString() {
        return this.brokerState;
    }

    public Instant created() {
        return this.created;
    }

    public DeploymentMode deploymentMode() {
        return DeploymentMode.fromValue(this.deploymentMode);
    }

    public String deploymentModeAsString() {
        return this.deploymentMode;
    }

    public String hostInstanceType() {
        return this.hostInstanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerSummary)) {
            return false;
        }
        BrokerSummary other = (BrokerSummary)obj;
        return Objects.equals(this.brokerArn(), other.brokerArn()) && Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.brokerName(), other.brokerName()) && Objects.equals(this.brokerStateAsString(), other.brokerStateAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.deploymentModeAsString(), other.deploymentModeAsString()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType());
    }

    public String toString() {
        return ToString.builder((String)"BrokerSummary").add("BrokerArn", (Object)this.brokerArn()).add("BrokerId", (Object)this.brokerId()).add("BrokerName", (Object)this.brokerName()).add("BrokerState", (Object)this.brokerStateAsString()).add("Created", (Object)this.created()).add("DeploymentMode", (Object)this.deploymentModeAsString()).add("HostInstanceType", (Object)this.hostInstanceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerArn": {
                return Optional.ofNullable(clazz.cast(this.brokerArn()));
            }
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "BrokerName": {
                return Optional.ofNullable(clazz.cast(this.brokerName()));
            }
            case "BrokerState": {
                return Optional.ofNullable(clazz.cast(this.brokerStateAsString()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "DeploymentMode": {
                return Optional.ofNullable(clazz.cast(this.deploymentModeAsString()));
            }
            case "HostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.hostInstanceType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerSummary, T> g) {
        return obj -> g.apply((BrokerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String brokerArn;
        private String brokerId;
        private String brokerName;
        private String brokerState;
        private Instant created;
        private String deploymentMode;
        private String hostInstanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerSummary model) {
            this.brokerArn(model.brokerArn);
            this.brokerId(model.brokerId);
            this.brokerName(model.brokerName);
            this.brokerState(model.brokerState);
            this.created(model.created);
            this.deploymentMode(model.deploymentMode);
            this.hostInstanceType(model.hostInstanceType);
        }

        public final String getBrokerArn() {
            return this.brokerArn;
        }

        @Override
        public final Builder brokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        public final void setBrokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final String getBrokerName() {
            return this.brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        public final String getBrokerState() {
            return this.brokerState;
        }

        @Override
        public final Builder brokerState(String brokerState) {
            this.brokerState = brokerState;
            return this;
        }

        @Override
        public final Builder brokerState(BrokerState brokerState) {
            this.brokerState(brokerState == null ? null : brokerState.toString());
            return this;
        }

        public final void setBrokerState(String brokerState) {
            this.brokerState = brokerState;
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final String getDeploymentMode() {
            return this.deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        @Override
        public final Builder deploymentMode(DeploymentMode deploymentMode) {
            this.deploymentMode(deploymentMode == null ? null : deploymentMode.toString());
            return this;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        public BrokerSummary build() {
            return new BrokerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerSummary> {
        public Builder brokerArn(String var1);

        public Builder brokerId(String var1);

        public Builder brokerName(String var1);

        public Builder brokerState(String var1);

        public Builder brokerState(BrokerState var1);

        public Builder created(Instant var1);

        public Builder deploymentMode(String var1);

        public Builder deploymentMode(DeploymentMode var1);

        public Builder hostInstanceType(String var1);
    }
}

