/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the
 * broker.
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeeklyStartTime implements SdkPojo, Serializable, ToCopyableBuilder<WeeklyStartTime.Builder, WeeklyStartTime> {
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WeeklyStartTime::dayOfWeekAsString)).setter(setter(Builder::dayOfWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dayOfWeek").build()).build();

    private static final SdkField<String> TIME_OF_DAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WeeklyStartTime::timeOfDay)).setter(setter(Builder::timeOfDay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOfDay").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WeeklyStartTime::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_WEEK_FIELD,
            TIME_OF_DAY_FIELD, TIME_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dayOfWeek;

    private final String timeOfDay;

    private final String timeZone;

    private WeeklyStartTime(BuilderImpl builder) {
        this.dayOfWeek = builder.dayOfWeek;
        this.timeOfDay = builder.timeOfDay;
        this.timeZone = builder.timeZone;
    }

    /**
     * Required. The day of the week.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return Required. The day of the week.
     * @see DayOfWeek
     */
    public DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(dayOfWeek);
    }

    /**
     * Required. The day of the week.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfWeek} will
     * return {@link DayOfWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dayOfWeekAsString}.
     * </p>
     * 
     * @return Required. The day of the week.
     * @see DayOfWeek
     */
    public String dayOfWeekAsString() {
        return dayOfWeek;
    }

    /**
     * Required. The time, in 24-hour format.
     * 
     * @return Required. The time, in 24-hour format.
     */
    public String timeOfDay() {
        return timeOfDay;
    }

    /**
     * The time zone, UTC by default, in either the Country/City format, or the UTC offset format.
     * 
     * @return The time zone, UTC by default, in either the Country/City format, or the UTC offset format.
     */
    public String timeZone() {
        return timeZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeOfDay());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklyStartTime)) {
            return false;
        }
        WeeklyStartTime other = (WeeklyStartTime) obj;
        return Objects.equals(dayOfWeekAsString(), other.dayOfWeekAsString()) && Objects.equals(timeOfDay(), other.timeOfDay())
                && Objects.equals(timeZone(), other.timeZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WeeklyStartTime").add("DayOfWeek", dayOfWeekAsString()).add("TimeOfDay", timeOfDay())
                .add("TimeZone", timeZone()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DayOfWeek":
            return Optional.ofNullable(clazz.cast(dayOfWeekAsString()));
        case "TimeOfDay":
            return Optional.ofNullable(clazz.cast(timeOfDay()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeeklyStartTime, T> g) {
        return obj -> g.apply((WeeklyStartTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeeklyStartTime> {
        /**
         * Required. The day of the week.
         * 
         * @param dayOfWeek
         *        Required. The day of the week.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(String dayOfWeek);

        /**
         * Required. The day of the week.
         * 
         * @param dayOfWeek
         *        Required. The day of the week.
         * @see DayOfWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DayOfWeek
         */
        Builder dayOfWeek(DayOfWeek dayOfWeek);

        /**
         * Required. The time, in 24-hour format.
         * 
         * @param timeOfDay
         *        Required. The time, in 24-hour format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOfDay(String timeOfDay);

        /**
         * The time zone, UTC by default, in either the Country/City format, or the UTC offset format.
         * 
         * @param timeZone
         *        The time zone, UTC by default, in either the Country/City format, or the UTC offset format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);
    }

    static final class BuilderImpl implements Builder {
        private String dayOfWeek;

        private String timeOfDay;

        private String timeZone;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklyStartTime model) {
            dayOfWeek(model.dayOfWeek);
            timeOfDay(model.timeOfDay);
            timeZone(model.timeZone);
        }

        public final String getDayOfWeek() {
            return dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        public final String getTimeOfDay() {
            return timeOfDay;
        }

        @Override
        public final Builder timeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
            return this;
        }

        public final void setTimeOfDay(String timeOfDay) {
            this.timeOfDay = timeOfDay;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public WeeklyStartTime build() {
            return new WeeklyStartTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
