/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An ActiveMQ user associated with the broker.
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<Boolean> CONSOLE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(User::consoleAccess)).setter(setter(Builder::consoleAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleAccess").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(User::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("password").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(User::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSOLE_ACCESS_FIELD,
            GROUPS_FIELD, PASSWORD_FIELD, USERNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean consoleAccess;

    private final List<String> groups;

    private final String password;

    private final String username;

    private User(BuilderImpl builder) {
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.password = builder.password;
        this.username = builder.username;
    }

    /**
     * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     * 
     * @return Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     */
    public Boolean consoleAccess() {
        return consoleAccess;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
     * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
     *         alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
     *         characters long.
     */
    public List<String> groups() {
        return groups;
    }

    /**
     * Required. The password of the ActiveMQ user. This value must be at least 12 characters long, must contain at
     * least 4 unique characters, and must not contain commas.
     * 
     * @return Required. The password of the ActiveMQ user. This value must be at least 12 characters long, must contain
     *         at least 4 unique characters, and must not contain commas.
     */
    public String password() {
        return password;
    }

    /**
     * Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes,
     * periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     * 
     * @return Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes,
     *         periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     */
    public String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(consoleAccess(), other.consoleAccess()) && Objects.equals(groups(), other.groups())
                && Objects.equals(password(), other.password()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("User").add("ConsoleAccess", consoleAccess()).add("Groups", groups()).add("Password", password())
                .add("Username", username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsoleAccess":
            return Optional.ofNullable(clazz.cast(consoleAccess()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         * 
         * @param consoleAccess
         *        Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consoleAccess(Boolean consoleAccess);

        /**
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
         * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * 
         * @param groups
         *        The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
         *        alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
         * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * 
         * @param groups
         *        The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
         *        alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * Required. The password of the ActiveMQ user. This value must be at least 12 characters long, must contain at
         * least 4 unique characters, and must not contain commas.
         * 
         * @param password
         *        Required. The password of the ActiveMQ user. This value must be at least 12 characters long, must
         *        contain at least 4 unique characters, and must not contain commas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes,
         * periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * 
         * @param username
         *        Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters,
         *        dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl implements Builder {
        private Boolean consoleAccess;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String password;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            consoleAccess(model.consoleAccess);
            groups(model.groups);
            password(model.password);
            username(model.username);
        }

        public final Boolean getConsoleAccess() {
            return consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        public final Collection<String> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
