/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Returns information about the XML element or attribute that was sanitized in the configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class SanitizationWarning implements SdkPojo, Serializable,
        ToCopyableBuilder<SanitizationWarning.Builder, SanitizationWarning> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SanitizationWarning::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeName").build()).build();

    private static final SdkField<String> ELEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SanitizationWarning::elementName)).setter(setter(Builder::elementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elementName").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SanitizationWarning::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            ELEMENT_NAME_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final String elementName;

    private final String reason;

    private SanitizationWarning(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.elementName = builder.elementName;
        this.reason = builder.reason;
    }

    /**
     * The name of the XML attribute that has been sanitized.
     * 
     * @return The name of the XML attribute that has been sanitized.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * The name of the XML element that has been sanitized.
     * 
     * @return The name of the XML element that has been sanitized.
     */
    public String elementName() {
        return elementName;
    }

    /**
     * Required. The reason for which the XML elements or attributes were sanitized.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SanitizationWarningReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Required. The reason for which the XML elements or attributes were sanitized.
     * @see SanitizationWarningReason
     */
    public SanitizationWarningReason reason() {
        return SanitizationWarningReason.fromValue(reason);
    }

    /**
     * Required. The reason for which the XML elements or attributes were sanitized.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link SanitizationWarningReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Required. The reason for which the XML elements or attributes were sanitized.
     * @see SanitizationWarningReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(elementName());
        hashCode = 31 * hashCode + Objects.hashCode(reasonAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SanitizationWarning)) {
            return false;
        }
        SanitizationWarning other = (SanitizationWarning) obj;
        return Objects.equals(attributeName(), other.attributeName()) && Objects.equals(elementName(), other.elementName())
                && Objects.equals(reasonAsString(), other.reasonAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SanitizationWarning").add("AttributeName", attributeName()).add("ElementName", elementName())
                .add("Reason", reasonAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "ElementName":
            return Optional.ofNullable(clazz.cast(elementName()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reasonAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SanitizationWarning, T> g) {
        return obj -> g.apply((SanitizationWarning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SanitizationWarning> {
        /**
         * The name of the XML attribute that has been sanitized.
         * 
         * @param attributeName
         *        The name of the XML attribute that has been sanitized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * The name of the XML element that has been sanitized.
         * 
         * @param elementName
         *        The name of the XML element that has been sanitized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elementName(String elementName);

        /**
         * Required. The reason for which the XML elements or attributes were sanitized.
         * 
         * @param reason
         *        Required. The reason for which the XML elements or attributes were sanitized.
         * @see SanitizationWarningReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SanitizationWarningReason
         */
        Builder reason(String reason);

        /**
         * Required. The reason for which the XML elements or attributes were sanitized.
         * 
         * @param reason
         *        Required. The reason for which the XML elements or attributes were sanitized.
         * @see SanitizationWarningReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SanitizationWarningReason
         */
        Builder reason(SanitizationWarningReason reason);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private String elementName;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(SanitizationWarning model) {
            attributeName(model.attributeName);
            elementName(model.elementName);
            reason(model.reason);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getElementName() {
            return elementName;
        }

        @Override
        public final Builder elementName(String elementName) {
            this.elementName = elementName;
            return this;
        }

        public final void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(SanitizationWarningReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public SanitizationWarning build() {
            return new SanitizationWarning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
