/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The list of information about logs to be enabled for the specified broker.
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingLogs implements SdkPojo, Serializable, ToCopyableBuilder<PendingLogs.Builder, PendingLogs> {
    private static final SdkField<Boolean> AUDIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PendingLogs::audit)).setter(setter(Builder::audit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audit").build()).build();

    private static final SdkField<Boolean> GENERAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PendingLogs::general)).setter(setter(Builder::general))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("general").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_FIELD, GENERAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean audit;

    private final Boolean general;

    private PendingLogs(BuilderImpl builder) {
        this.audit = builder.audit;
        this.general = builder.general;
    }

    /**
     * Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     * 
     * @return Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     */
    public Boolean audit() {
        return audit;
    }

    /**
     * Enables general logging.
     * 
     * @return Enables general logging.
     */
    public Boolean general() {
        return general;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audit());
        hashCode = 31 * hashCode + Objects.hashCode(general());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingLogs)) {
            return false;
        }
        PendingLogs other = (PendingLogs) obj;
        return Objects.equals(audit(), other.audit()) && Objects.equals(general(), other.general());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PendingLogs").add("Audit", audit()).add("General", general()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audit":
            return Optional.ofNullable(clazz.cast(audit()));
        case "General":
            return Optional.ofNullable(clazz.cast(general()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingLogs, T> g) {
        return obj -> g.apply((PendingLogs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingLogs> {
        /**
         * Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
         * 
         * @param audit
         *        Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
         *        logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audit(Boolean audit);

        /**
         * Enables general logging.
         * 
         * @param general
         *        Enables general logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder general(Boolean general);
    }

    static final class BuilderImpl implements Builder {
        private Boolean audit;

        private Boolean general;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingLogs model) {
            audit(model.audit);
            general(model.general);
        }

        public final Boolean getAudit() {
            return audit;
        }

        @Override
        public final Builder audit(Boolean audit) {
            this.audit = audit;
            return this;
        }

        public final void setAudit(Boolean audit) {
            this.audit = audit;
        }

        public final Boolean getGeneral() {
            return general;
        }

        @Override
        public final Builder general(Boolean general) {
            this.general = general;
            return this;
        }

        public final void setGeneral(Boolean general) {
            this.general = general;
        }

        @Override
        public PendingLogs build() {
            return new PendingLogs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
